/*
 * Decompiled with CFR 0.152.
 */
package com.daas.nros.openapi.utils;

import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.openapi.utils.ResponseUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ValidateUtils {
    private static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public static <T> List<String> validate(T t) {
        Validator validator = factory.getValidator();
        Set constraintViolations = validator.validate(t, new Class[0]);
        ArrayList<String> messageList = new ArrayList<String>();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            messageList.add(constraintViolation.getMessage());
        }
        return messageList;
    }

    public static <T> ResponseData validateAndAdvice(T t) {
        if (t == null) {
            return ResponseUtil.getFailedData("param can't be null!", null);
        }
        List<String> validateList = ValidateUtils.validate(t);
        if (validateList != null && !validateList.isEmpty()) {
            HashSet<String> set = new HashSet<String>(validateList);
            validateList = new ArrayList<String>(set);
            StringBuilder sb = new StringBuilder();
            for (String message : validateList) {
                sb.append(message + " ");
            }
            return ResponseUtil.getFailedData(sb.toString(), null);
        }
        return null;
    }

    public static <T> ResponseData validate(T object, String msg, Class ... groups) {
        if (object == null) {
            return ResponseUtil.getFailedData(msg, null);
        }
        Set validator = factory.getValidator().validate(object, groups);
        return validator != null && validator.iterator().hasNext() ? ResponseUtil.getFailedData(((ConstraintViolation)validator.iterator().next()).getMessage(), null) : null;
    }
}

