package com.daas.nros.core.rpc;

import com.bizvane.core.facade.models.po.TracePO;
import com.bizvane.core.facade.models.po.TraceRecordPO;
import com.bizvane.core.facade.models.vo.TraceRecordPageVo;
import com.bizvane.core.facade.models.vo.TraceRecordVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "${feign.client.core.name}", path = "${feign.client.core.path}/coreTrace")
@Api(value = "Trace接口", tags = {"Trace接口"})
public interface CoreTraceFeign {

    @ApiOperation(value = "新增trace")
    @RequestMapping(value = "/insertTrace", method = RequestMethod.POST)
    ResponseData<Long> insertTrace(@RequestBody TracePO vo);


    @ApiOperation(value = "查询trace")
    @RequestMapping(value = "/selectByTraceId", method = RequestMethod.POST)
    ResponseData<TracePO> selectByTraceId(@RequestParam Long traceId);


    @ApiOperation(value = "根据traceId插入一条trace记录")
    @RequestMapping(value = "/saveTraceRecord", method = RequestMethod.POST)
    ResponseData saveTraceRecord(@RequestBody TraceRecordVo vo);


    @ApiOperation(value = "根据unionid查询最近一条trace记录")
    @RequestMapping(value = "/selectTraceRecord", method = RequestMethod.POST)
    ResponseData<TraceRecordPO> selectTraceRecord(@RequestBody TraceRecordVo vo);

    @ApiOperation(value = "根据unionid查询最近一百条trace记录")
    @RequestMapping(value = "/selectTraceRecordList", method = RequestMethod.POST)
    ResponseData<PageInfo<TraceRecordPO>> selectTraceRecordList(@RequestBody TraceRecordPageVo vo);

    @ApiOperation(value = "根据unionid删除record记录供测试使用")
    @RequestMapping(value = "/deleteTraceRecordByUnionId", method = RequestMethod.POST)
    boolean deleteTraceRecordByUnionId(@RequestParam("unionId") String unionId);
}
