package com.daas.nros.connector.burgeon.api;

import com.alibaba.fastjson.JSONObject;
import com.daas.nros.connector.burgeon.model.vo.VgAddCouponCrmVO;
import com.daas.nros.connector.model.result.Result;

public interface VgCouponService {

    /**
     * 单张发券
     *
     * @param vgAddCouponCrmVO
     * @return
     */
    Result<JSONObject> sendCoupon(VgAddCouponCrmVO vgAddCouponCrmVO);

    /**
     * 批量发券
     *
     * @param requestVO
     * @return
     */
    Result<JSONObject> sendCouponBatch(JSONObject requestVO);

    /**
     * 券规则新增
     *
     * @param requestVO
     * @return
     */
    Result<JSONObject> addCouponGrp(JSONObject requestVO, String tag);

    /**
     * 券规则作废
     *
     * @param requestVO
     * @return
     */
    Result<JSONObject> invalidCouponGrp(JSONObject requestVO, String tag);

    /**
     * 券规则修改-目前只支持商品修改
     *
     * @param requestVO
     * @return
     */
    Result<JSONObject> modifyCouponGrp(JSONObject requestVO, String tag);

    /**
     * 券转赠
     *
     * @param requestVO
     * @return
     */
    Result<JSONObject> giveCoupon(JSONObject requestVO);

    /**
     * 券批量作废
     *
     * @param requestVO
     * @return
     */
    Result<JSONObject> cancelCouponBatch(JSONObject requestVO, String tag);

    /**
     * 券核销
     *
     * @param requestVO
     * @return
     */
    Result<JSONObject> useCoupon(JSONObject requestVO, String tag);

}
