package com.daas.nros.connector.burgeon.api;

import com.daas.nros.connector.burgeon.model.req.SnyMemberCouponReq;
import com.daas.nros.connector.burgeon.model.req.SnyMemberRightsReq;
import com.daas.nros.connector.burgeon.model.vo.VgAddCouponDefinitionVo;
import com.daas.nros.connector.burgeon.model.vo.VgAddGiveCouponVo;
import com.daas.nros.connector.burgeon.model.vo.VgCancelCouponVo;
import com.daas.nros.connector.model.result.Result;


import java.util.List;

public interface CrmJointService {

    void init();

    void remove();

    /**
     * 券定义
     *
     * @param vgAddCouponDefinitionVo
     * @return
     */
    Result snyCouponInfo(VgAddCouponDefinitionVo vgAddCouponDefinitionVo);

    /**
     * 券定义-修改
     *
     * @param vgAddCouponDefinitionVo
     * @return
     */
    Result modifyCouponInfo(VgAddCouponDefinitionVo vgAddCouponDefinitionVo);

    /**
     * 发券
     *
     * @param couponReqList
     * @return
     */
    Result snyMemberCoupon(List<SnyMemberCouponReq> couponReqList);

    /**
     * 优惠券作废
     *
     * @param vgCancelCouponVo
     * @return
     */
    Result snyCouponStatus(VgCancelCouponVo vgCancelCouponVo);


    /**
     * 优惠券核销
     *
     * @param vgCancelCouponVo
     * @return
     */
    Result snyCouponCancel(VgCancelCouponVo vgCancelCouponVo);

    /**
     * 优惠券转增
     *
     * @param vgAddGiveCouponVo
     * @return
     */
    Result snyCouponTransfer(VgAddGiveCouponVo vgAddGiveCouponVo);

    /**
     * 会员权益
     *
     * @param snyMemberRightsReq
     * @return
     */
    Result snyMemberRights(SnyMemberRightsReq snyMemberRightsReq);

}