package com.daas.nros.connector.api;

import com.daas.nros.connector.model.po.ConnectConfigBean;

import java.util.List;

public interface ConnectConfigBeanService {

    /**
     * 根据redis中ConnectConfig数据获取品牌,按品牌从db加载t_connect_config_bean表进redis
     */
    void refreshRedisAll();

    /**
     * 刷新redis
     */
    void refreshRedisIcrm();

    /**
     * 根据线上品牌id,和接口类获取对应实现
     *
     * @param onlineBrandId 线上品牌id
     * @param methodName
     * @param cls           接口类Class
     * @return 品牌id对应实现类
     */
    Object queryBeanNameByBrandIdAndClass(Long onlineBrandId, String methodName, Class cls);

    /**
     * 查询beanName
     *
     * @param onlineBrandId
     * @return
     */
    ConnectConfigBean queryBeanNameByBrandId(Long onlineBrandId);

    /**
     * 查询beanName
     *
     * @return
     */
    List<ConnectConfigBean> queryBeanNameAll();

}
