/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

class PathInfoHandler {
    private final Map<OutputFile, String> pathInfo = new HashMap<OutputFile, String>();
    private final String outputDir;
    private final PackageConfig packageConfig;

    PathInfoHandler(GlobalConfig globalConfig, TemplateConfig templateConfig, PackageConfig packageConfig) {
        this.outputDir = globalConfig.getOutputDir();
        this.packageConfig = packageConfig;
        this.setDefaultPathInfo(globalConfig, templateConfig);
        Map<OutputFile, String> pathInfo = packageConfig.getPathInfo();
        if (CollectionUtils.isNotEmpty(pathInfo)) {
            this.pathInfo.putAll(pathInfo);
        }
    }

    private void setDefaultPathInfo(GlobalConfig globalConfig, TemplateConfig templateConfig) {
        this.putPathInfo(templateConfig.getEntity(globalConfig.isKotlin()), OutputFile.entity, "Entity");
        this.putPathInfo(templateConfig.getMapper(), OutputFile.mapper, "Mapper");
        this.putPathInfo(templateConfig.getXml(), OutputFile.xml, "Xml");
        this.putPathInfo(templateConfig.getService(), OutputFile.service, "Service");
        this.putPathInfo(templateConfig.getServiceImpl(), OutputFile.serviceImpl, "ServiceImpl");
        this.putPathInfo(templateConfig.getController(), OutputFile.controller, "Controller");
        this.putPathInfo(OutputFile.parent, "Parent");
    }

    private void putPathInfo(String template, OutputFile outputFile, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            this.putPathInfo(outputFile, module);
        }
    }

    private void putPathInfo(OutputFile outputFile, String module) {
        this.pathInfo.putIfAbsent(outputFile, this.joinPath(this.outputDir, this.packageConfig.getPackageInfo(module)));
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    public Map<OutputFile, String> getPathInfo() {
        return this.pathInfo;
    }
}

