/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class StrategyConfig {
    private boolean isCapitalMode = false;
    private boolean skipView = false;
    private NamingStrategy naming = NamingStrategy.no_change;
    private NamingStrategy columnNaming = null;
    private String[] tablePrefix;
    private String[] fieldPrefix;
    private String superEntityClass;
    private String[] superEntityColumns;
    private String superMapperClass = "com.baomidou.mybatisplus.core.mapper.BaseMapper";
    private String superServiceClass = "com.baomidou.mybatisplus.extension.service.IService";
    private String superServiceImplClass = "com.baomidou.mybatisplus.extension.service.impl.ServiceImpl";
    private String superControllerClass;
    private String[] include = null;
    private String[] exclude = null;
    private boolean entityColumnConstant = false;
    private boolean entityBuilderModel = false;
    private boolean entityLombokModel = false;
    private boolean entityBooleanColumnRemoveIsPrefix = false;
    private boolean restControllerStyle = false;
    private boolean controllerMappingHyphenStyle = false;
    private boolean entityTableFieldAnnotationEnable = false;
    private String versionFieldName;
    private String logicDeleteFieldName;
    private List<TableFill> tableFillList = null;

    public boolean isCapitalModeNaming(String word) {
        return this.isCapitalMode && StringUtils.isCapitalMode((String)word);
    }

    public boolean containsTablePrefix(String tableName) {
        String[] tps;
        if (null != tableName && null != (tps = this.getTablePrefix())) {
            for (String tp : tps) {
                if (!tableName.contains(tp)) continue;
                return true;
            }
        }
        return false;
    }

    public NamingStrategy getColumnNaming() {
        if (null == this.columnNaming) {
            return this.naming;
        }
        return this.columnNaming;
    }

    public StrategyConfig setTablePrefix(String ... tablePrefix) {
        this.tablePrefix = tablePrefix;
        return this;
    }

    public boolean includeSuperEntityColumns(String fieldName) {
        if (null != this.superEntityColumns) {
            for (String column : this.superEntityColumns) {
                if (!column.equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public StrategyConfig setSuperEntityColumns(String ... superEntityColumns) {
        this.superEntityColumns = superEntityColumns;
        return this;
    }

    public StrategyConfig setInclude(String ... include) {
        this.include = include;
        return this;
    }

    public StrategyConfig setExclude(String ... exclude) {
        this.exclude = exclude;
        return this;
    }

    public StrategyConfig setFieldPrefix(String ... fieldPrefixs) {
        this.fieldPrefix = fieldPrefixs;
        return this;
    }

    public StrategyConfig setSuperEntityClass(String superEntityClass) {
        this.superEntityClass = superEntityClass;
        return this;
    }

    public StrategyConfig setSuperEntityClass(Class<?> clazz) {
        return this.setSuperEntityClass(clazz, null);
    }

    public StrategyConfig setSuperEntityClass(Class<?> clazz, NamingStrategy columnNaming) {
        if (null != columnNaming) {
            this.columnNaming = columnNaming;
        }
        this.superEntityClass = clazz.getSimpleName();
        this.convertSuperEntityColumns(clazz);
        return this;
    }

    protected void convertSuperEntityColumns(Class<?> clazz) {
        List fields = TableInfoHelper.getAllFields(clazz);
        if (CollectionUtils.isNotEmpty((Collection)fields)) {
            this.superEntityColumns = (String[])fields.stream().map(field -> {
                if (null == this.columnNaming || this.columnNaming == NamingStrategy.no_change) {
                    return field.getName();
                }
                return StringUtils.camelToUnderline((String)field.getName());
            }).collect(Collectors.toSet()).stream().toArray(String[]::new);
        }
    }

    @Deprecated
    public StrategyConfig entityTableFieldAnnotationEnable(boolean isEnableAnnotation) {
        this.entityTableFieldAnnotationEnable = isEnableAnnotation;
        return this;
    }

    public boolean isCapitalMode() {
        return this.isCapitalMode;
    }

    public boolean isSkipView() {
        return this.skipView;
    }

    public NamingStrategy getNaming() {
        return this.naming;
    }

    public String[] getTablePrefix() {
        return this.tablePrefix;
    }

    public String[] getFieldPrefix() {
        return this.fieldPrefix;
    }

    public String getSuperEntityClass() {
        return this.superEntityClass;
    }

    public String[] getSuperEntityColumns() {
        return this.superEntityColumns;
    }

    public String getSuperMapperClass() {
        return this.superMapperClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public String[] getInclude() {
        return this.include;
    }

    public String[] getExclude() {
        return this.exclude;
    }

    public boolean isEntityColumnConstant() {
        return this.entityColumnConstant;
    }

    public boolean isEntityBuilderModel() {
        return this.entityBuilderModel;
    }

    public boolean isEntityLombokModel() {
        return this.entityLombokModel;
    }

    public boolean isEntityBooleanColumnRemoveIsPrefix() {
        return this.entityBooleanColumnRemoveIsPrefix;
    }

    public boolean isRestControllerStyle() {
        return this.restControllerStyle;
    }

    public boolean isControllerMappingHyphenStyle() {
        return this.controllerMappingHyphenStyle;
    }

    public boolean isEntityTableFieldAnnotationEnable() {
        return this.entityTableFieldAnnotationEnable;
    }

    public String getVersionFieldName() {
        return this.versionFieldName;
    }

    public String getLogicDeleteFieldName() {
        return this.logicDeleteFieldName;
    }

    public List<TableFill> getTableFillList() {
        return this.tableFillList;
    }

    public StrategyConfig setCapitalMode(boolean isCapitalMode) {
        this.isCapitalMode = isCapitalMode;
        return this;
    }

    public StrategyConfig setSkipView(boolean skipView) {
        this.skipView = skipView;
        return this;
    }

    public StrategyConfig setNaming(NamingStrategy naming) {
        this.naming = naming;
        return this;
    }

    public StrategyConfig setColumnNaming(NamingStrategy columnNaming) {
        this.columnNaming = columnNaming;
        return this;
    }

    public StrategyConfig setSuperMapperClass(String superMapperClass) {
        this.superMapperClass = superMapperClass;
        return this;
    }

    public StrategyConfig setSuperServiceClass(String superServiceClass) {
        this.superServiceClass = superServiceClass;
        return this;
    }

    public StrategyConfig setSuperServiceImplClass(String superServiceImplClass) {
        this.superServiceImplClass = superServiceImplClass;
        return this;
    }

    public StrategyConfig setSuperControllerClass(String superControllerClass) {
        this.superControllerClass = superControllerClass;
        return this;
    }

    public StrategyConfig setEntityColumnConstant(boolean entityColumnConstant) {
        this.entityColumnConstant = entityColumnConstant;
        return this;
    }

    public StrategyConfig setEntityBuilderModel(boolean entityBuilderModel) {
        this.entityBuilderModel = entityBuilderModel;
        return this;
    }

    public StrategyConfig setEntityLombokModel(boolean entityLombokModel) {
        this.entityLombokModel = entityLombokModel;
        return this;
    }

    public StrategyConfig setEntityBooleanColumnRemoveIsPrefix(boolean entityBooleanColumnRemoveIsPrefix) {
        this.entityBooleanColumnRemoveIsPrefix = entityBooleanColumnRemoveIsPrefix;
        return this;
    }

    public StrategyConfig setRestControllerStyle(boolean restControllerStyle) {
        this.restControllerStyle = restControllerStyle;
        return this;
    }

    public StrategyConfig setControllerMappingHyphenStyle(boolean controllerMappingHyphenStyle) {
        this.controllerMappingHyphenStyle = controllerMappingHyphenStyle;
        return this;
    }

    public StrategyConfig setEntityTableFieldAnnotationEnable(boolean entityTableFieldAnnotationEnable) {
        this.entityTableFieldAnnotationEnable = entityTableFieldAnnotationEnable;
        return this;
    }

    public StrategyConfig setVersionFieldName(String versionFieldName) {
        this.versionFieldName = versionFieldName;
        return this;
    }

    public StrategyConfig setLogicDeleteFieldName(String logicDeleteFieldName) {
        this.logicDeleteFieldName = logicDeleteFieldName;
        return this;
    }

    public StrategyConfig setTableFillList(List<TableFill> tableFillList) {
        this.tableFillList = tableFillList;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StrategyConfig)) {
            return false;
        }
        StrategyConfig other = (StrategyConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCapitalMode() != other.isCapitalMode()) {
            return false;
        }
        if (this.isSkipView() != other.isSkipView()) {
            return false;
        }
        NamingStrategy this$naming = this.getNaming();
        NamingStrategy other$naming = other.getNaming();
        if (this$naming == null ? other$naming != null : !((Object)((Object)this$naming)).equals((Object)other$naming)) {
            return false;
        }
        NamingStrategy this$columnNaming = this.getColumnNaming();
        NamingStrategy other$columnNaming = other.getColumnNaming();
        if (this$columnNaming == null ? other$columnNaming != null : !((Object)((Object)this$columnNaming)).equals((Object)other$columnNaming)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTablePrefix(), other.getTablePrefix())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getFieldPrefix(), other.getFieldPrefix())) {
            return false;
        }
        String this$superEntityClass = this.getSuperEntityClass();
        String other$superEntityClass = other.getSuperEntityClass();
        if (this$superEntityClass == null ? other$superEntityClass != null : !this$superEntityClass.equals(other$superEntityClass)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSuperEntityColumns(), other.getSuperEntityColumns())) {
            return false;
        }
        String this$superMapperClass = this.getSuperMapperClass();
        String other$superMapperClass = other.getSuperMapperClass();
        if (this$superMapperClass == null ? other$superMapperClass != null : !this$superMapperClass.equals(other$superMapperClass)) {
            return false;
        }
        String this$superServiceClass = this.getSuperServiceClass();
        String other$superServiceClass = other.getSuperServiceClass();
        if (this$superServiceClass == null ? other$superServiceClass != null : !this$superServiceClass.equals(other$superServiceClass)) {
            return false;
        }
        String this$superServiceImplClass = this.getSuperServiceImplClass();
        String other$superServiceImplClass = other.getSuperServiceImplClass();
        if (this$superServiceImplClass == null ? other$superServiceImplClass != null : !this$superServiceImplClass.equals(other$superServiceImplClass)) {
            return false;
        }
        String this$superControllerClass = this.getSuperControllerClass();
        String other$superControllerClass = other.getSuperControllerClass();
        if (this$superControllerClass == null ? other$superControllerClass != null : !this$superControllerClass.equals(other$superControllerClass)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getInclude(), other.getInclude())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExclude(), other.getExclude())) {
            return false;
        }
        if (this.isEntityColumnConstant() != other.isEntityColumnConstant()) {
            return false;
        }
        if (this.isEntityBuilderModel() != other.isEntityBuilderModel()) {
            return false;
        }
        if (this.isEntityLombokModel() != other.isEntityLombokModel()) {
            return false;
        }
        if (this.isEntityBooleanColumnRemoveIsPrefix() != other.isEntityBooleanColumnRemoveIsPrefix()) {
            return false;
        }
        if (this.isRestControllerStyle() != other.isRestControllerStyle()) {
            return false;
        }
        if (this.isControllerMappingHyphenStyle() != other.isControllerMappingHyphenStyle()) {
            return false;
        }
        if (this.isEntityTableFieldAnnotationEnable() != other.isEntityTableFieldAnnotationEnable()) {
            return false;
        }
        String this$versionFieldName = this.getVersionFieldName();
        String other$versionFieldName = other.getVersionFieldName();
        if (this$versionFieldName == null ? other$versionFieldName != null : !this$versionFieldName.equals(other$versionFieldName)) {
            return false;
        }
        String this$logicDeleteFieldName = this.getLogicDeleteFieldName();
        String other$logicDeleteFieldName = other.getLogicDeleteFieldName();
        if (this$logicDeleteFieldName == null ? other$logicDeleteFieldName != null : !this$logicDeleteFieldName.equals(other$logicDeleteFieldName)) {
            return false;
        }
        List<TableFill> this$tableFillList = this.getTableFillList();
        List<TableFill> other$tableFillList = other.getTableFillList();
        return !(this$tableFillList == null ? other$tableFillList != null : !((Object)this$tableFillList).equals(other$tableFillList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StrategyConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCapitalMode() ? 79 : 97);
        result = result * 59 + (this.isSkipView() ? 79 : 97);
        NamingStrategy $naming = this.getNaming();
        result = result * 59 + ($naming == null ? 43 : ((Object)((Object)$naming)).hashCode());
        NamingStrategy $columnNaming = this.getColumnNaming();
        result = result * 59 + ($columnNaming == null ? 43 : ((Object)((Object)$columnNaming)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTablePrefix());
        result = result * 59 + Arrays.deepHashCode(this.getFieldPrefix());
        String $superEntityClass = this.getSuperEntityClass();
        result = result * 59 + ($superEntityClass == null ? 43 : $superEntityClass.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSuperEntityColumns());
        String $superMapperClass = this.getSuperMapperClass();
        result = result * 59 + ($superMapperClass == null ? 43 : $superMapperClass.hashCode());
        String $superServiceClass = this.getSuperServiceClass();
        result = result * 59 + ($superServiceClass == null ? 43 : $superServiceClass.hashCode());
        String $superServiceImplClass = this.getSuperServiceImplClass();
        result = result * 59 + ($superServiceImplClass == null ? 43 : $superServiceImplClass.hashCode());
        String $superControllerClass = this.getSuperControllerClass();
        result = result * 59 + ($superControllerClass == null ? 43 : $superControllerClass.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getInclude());
        result = result * 59 + Arrays.deepHashCode(this.getExclude());
        result = result * 59 + (this.isEntityColumnConstant() ? 79 : 97);
        result = result * 59 + (this.isEntityBuilderModel() ? 79 : 97);
        result = result * 59 + (this.isEntityLombokModel() ? 79 : 97);
        result = result * 59 + (this.isEntityBooleanColumnRemoveIsPrefix() ? 79 : 97);
        result = result * 59 + (this.isRestControllerStyle() ? 79 : 97);
        result = result * 59 + (this.isControllerMappingHyphenStyle() ? 79 : 97);
        result = result * 59 + (this.isEntityTableFieldAnnotationEnable() ? 79 : 97);
        String $versionFieldName = this.getVersionFieldName();
        result = result * 59 + ($versionFieldName == null ? 43 : $versionFieldName.hashCode());
        String $logicDeleteFieldName = this.getLogicDeleteFieldName();
        result = result * 59 + ($logicDeleteFieldName == null ? 43 : $logicDeleteFieldName.hashCode());
        List<TableFill> $tableFillList = this.getTableFillList();
        result = result * 59 + ($tableFillList == null ? 43 : ((Object)$tableFillList).hashCode());
        return result;
    }

    public String toString() {
        return "StrategyConfig(isCapitalMode=" + this.isCapitalMode() + ", skipView=" + this.isSkipView() + ", naming=" + (Object)((Object)this.getNaming()) + ", columnNaming=" + (Object)((Object)this.getColumnNaming()) + ", tablePrefix=" + Arrays.deepToString(this.getTablePrefix()) + ", fieldPrefix=" + Arrays.deepToString(this.getFieldPrefix()) + ", superEntityClass=" + this.getSuperEntityClass() + ", superEntityColumns=" + Arrays.deepToString(this.getSuperEntityColumns()) + ", superMapperClass=" + this.getSuperMapperClass() + ", superServiceClass=" + this.getSuperServiceClass() + ", superServiceImplClass=" + this.getSuperServiceImplClass() + ", superControllerClass=" + this.getSuperControllerClass() + ", include=" + Arrays.deepToString(this.getInclude()) + ", exclude=" + Arrays.deepToString(this.getExclude()) + ", entityColumnConstant=" + this.isEntityColumnConstant() + ", entityBuilderModel=" + this.isEntityBuilderModel() + ", entityLombokModel=" + this.isEntityLombokModel() + ", entityBooleanColumnRemoveIsPrefix=" + this.isEntityBooleanColumnRemoveIsPrefix() + ", restControllerStyle=" + this.isRestControllerStyle() + ", controllerMappingHyphenStyle=" + this.isControllerMappingHyphenStyle() + ", entityTableFieldAnnotationEnable=" + this.isEntityTableFieldAnnotationEnable() + ", versionFieldName=" + this.getVersionFieldName() + ", logicDeleteFieldName=" + this.getLogicDeleteFieldName() + ", tableFillList=" + this.getTableFillList() + ")";
    }
}

