/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.spring.boot.autoconfigure;

import cn.beecp.BeeDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.atomikos.jdbc.AtomikosDataSourceBean;
import com.baomidou.dynamic.datasource.creator.atomikos.AtomikosDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.basic.BasicDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.beecp.BeeCpDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.dbcp.Dbcp2DataSourceCreator;
import com.baomidou.dynamic.datasource.creator.druid.DruidDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.hikaricp.HikariDataSourceCreator;
import com.baomidou.dynamic.datasource.creator.jndi.JndiDataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.tx.AtomikosTransactionFactory;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.ibatis.transaction.TransactionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
public class DynamicDataSourceCreatorAutoConfiguration {
    public static final int JNDI_ORDER = 1000;
    public static final int DRUID_ORDER = 2000;
    public static final int HIKARI_ORDER = 3000;
    public static final int BEECP_ORDER = 4000;
    public static final int DBCP2_ORDER = 5000;
    public static final int ATOMIKOS_ORDER = 6000;
    public static final int DEFAULT_ORDER = 7000;
    private final DynamicDataSourceProperties properties;

    @Bean
    @Order(value=7000)
    public BasicDataSourceCreator basicDataSourceCreator() {
        return new BasicDataSourceCreator();
    }

    @Bean
    @Order(value=1000)
    public JndiDataSourceCreator jndiDataSourceCreator() {
        return new JndiDataSourceCreator();
    }

    @Bean
    @Order(value=2000)
    @ConditionalOnClass(value={DruidDataSource.class})
    public DruidDataSourceCreator druidDataSourceCreator() {
        return new DruidDataSourceCreator(this.properties.getDruid());
    }

    @Bean
    @Order(value=3000)
    @ConditionalOnClass(value={HikariDataSource.class})
    public HikariDataSourceCreator hikariDataSourceCreator() {
        return new HikariDataSourceCreator(this.properties.getHikari());
    }

    @Bean
    @Order(value=4000)
    @ConditionalOnClass(value={BeeDataSource.class})
    public BeeCpDataSourceCreator beeCpDataSourceCreator() {
        return new BeeCpDataSourceCreator(this.properties.getBeecp());
    }

    @Bean
    @Order(value=5000)
    @ConditionalOnClass(value={BasicDataSource.class})
    public Dbcp2DataSourceCreator dbcp2DataSourceCreator() {
        return new Dbcp2DataSourceCreator(this.properties.getDbcp2());
    }

    @Bean
    @Order(value=6000)
    @ConditionalOnClass(value={AtomikosDataSourceBean.class})
    public AtomikosDataSourceCreator atomikosDataSourceCreator() {
        return new AtomikosDataSourceCreator(this.properties.getAtomikos());
    }

    @Bean
    @ConditionalOnClass(value={AtomikosDataSourceBean.class, TransactionFactory.class})
    public TransactionFactory atomikosTransactionFactory() {
        return new AtomikosTransactionFactory();
    }

    public DynamicDataSourceCreatorAutoConfiguration(DynamicDataSourceProperties properties) {
        this.properties = properties;
    }
}

