/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.imp;

import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.Repository;
import com.atomikos.recovery.TxState;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryRepository
implements Repository {
    private Map<String, CoordinatorLogEntry> storage = new ConcurrentHashMap<String, CoordinatorLogEntry>();
    private boolean closed = true;

    public void init() {
        this.closed = false;
    }

    public synchronized void put(String id, CoordinatorLogEntry coordinatorLogEntry) throws IllegalArgumentException {
        CoordinatorLogEntry existing = this.storage.get(id);
        if (existing != null && existing == coordinatorLogEntry) {
            throw new IllegalArgumentException("cannot put the same coordinatorLogEntry twice");
        }
        if (coordinatorLogEntry.getResultingState().isFinalState()) {
            this.storage.remove(id);
        } else {
            this.storage.put(id, coordinatorLogEntry);
        }
    }

    public synchronized CoordinatorLogEntry get(String coordinatorId) {
        return this.storage.get(coordinatorId);
    }

    public synchronized Collection<CoordinatorLogEntry> findAllCommittingCoordinatorLogEntries() {
        HashSet<CoordinatorLogEntry> res = new HashSet<CoordinatorLogEntry>();
        Collection<CoordinatorLogEntry> allCoordinatorLogEntry = this.storage.values();
        for (CoordinatorLogEntry coordinatorLogEntry : allCoordinatorLogEntry) {
            if (coordinatorLogEntry.getResultingState() != TxState.COMMITTING) continue;
            res.add(coordinatorLogEntry);
        }
        return res;
    }

    public void close() {
        this.storage.clear();
        this.closed = true;
    }

    public Collection<CoordinatorLogEntry> getAllCoordinatorLogEntries() {
        return this.storage.values();
    }

    public void writeCheckpoint(Collection<CoordinatorLogEntry> checkpointContent) {
        this.storage.clear();
        for (CoordinatorLogEntry coordinatorLogEntry : checkpointContent) {
            this.storage.put(coordinatorLogEntry.id, coordinatorLogEntry);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

