/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.auth.ServiceSignature;
import com.aliyun.common.comm.ResponseHandler;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.utils.DateUtil;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.ots.internal.OTSExceptionFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class OTSValidationResponseHandler
implements ResponseHandler {
    private static final String OTS_HEADER_PREFIX = "x-ots-";
    private static final String OTS_DATE_HEADER = "x-ots-date";
    private static final String CONTENT_MD5_HEADER = "Content-Md5";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String MISSING_HEADER_FORMAT = "\u8fd4\u56de\u7ed3\u679c\u7f3a\u5931\u5934%s\u3002";
    private int responseExpireMinutes = 15;
    private ServiceCredentials credentials;
    private String otsAction;

    public OTSValidationResponseHandler(ServiceCredentials credentials, String otsAction) {
        assert (credentials != null && otsAction != null);
        this.credentials = credentials;
        this.otsAction = otsAction;
    }

    public int getResponseExpireMinutes() {
        return this.responseExpireMinutes;
    }

    public void setResponseExpireMinutes(int responseExpireMinutes) {
        this.responseExpireMinutes = responseExpireMinutes;
    }

    @Override
    public void handle(ResponseMessage responseData) throws ClientException {
        Date responseDate;
        Map<String, String> headers = responseData.getHeaders();
        if (!headers.containsKey(OTS_DATE_HEADER)) {
            throw OTSExceptionFactory.createResponseException(String.format(MISSING_HEADER_FORMAT, OTS_DATE_HEADER), null);
        }
        if (!headers.containsKey(CONTENT_MD5_HEADER)) {
            throw OTSExceptionFactory.createResponseException(String.format(MISSING_HEADER_FORMAT, CONTENT_MD5_HEADER), null);
        }
        if (!headers.containsKey(CONTENT_TYPE_HEADER)) {
            throw OTSExceptionFactory.createResponseException(String.format(MISSING_HEADER_FORMAT, CONTENT_TYPE_HEADER), null);
        }
        if (!headers.containsKey(AUTHORIZATION_HEADER)) {
            throw OTSExceptionFactory.createResponseException(String.format(MISSING_HEADER_FORMAT, AUTHORIZATION_HEADER), null);
        }
        String NEW_LINE = "\n";
        try {
            responseDate = DateUtil.parseRfc822Date(headers.get(OTS_DATE_HEADER));
        }
        catch (ParseException e) {
            throw OTSExceptionFactory.createResponseException("\u8fd4\u56de\u7ed3\u679c\u8d85\u65f6\u3002", null);
        }
        Date now = new Date();
        long span = (now.getTime() - responseDate.getTime()) / 60000L;
        if (span > (long)this.responseExpireMinutes) {
            throw OTSExceptionFactory.createResponseException("\u8fd4\u56de\u7ed3\u679c\u8d85\u65f6\u3002", null);
        }
        StringBuilder canonicalizedOtsHeader = new StringBuilder();
        for (String key : headers.keySet()) {
            if (!key.startsWith(OTS_HEADER_PREFIX)) continue;
            canonicalizedOtsHeader.append(String.format("%s:%s%s", key, headers.get(key), "\n"));
        }
        String contentMd5 = headers.get(CONTENT_MD5_HEADER);
        String contentType = headers.get(CONTENT_TYPE_HEADER);
        String canonicalizedResource = "/" + this.otsAction;
        String data = contentMd5 + "\n" + contentType + "\n" + canonicalizedOtsHeader.toString() + canonicalizedResource;
        String actualSign = ServiceSignature.create().computeSignature(this.credentials.getAccessKeySecret(), data);
        String authHeader = headers.get(AUTHORIZATION_HEADER);
        boolean authEqual = false;
        if (authHeader.contains(":")) {
            String[] arr = authHeader.split(":");
            authEqual = arr[arr.length - 1].endsWith(actualSign);
        }
        if (!authEqual) {
            throw OTSExceptionFactory.createResponseException("\u8fd4\u56de\u7ed3\u679c\u6388\u6743\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25\u3002", null);
        }
    }
}

