/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ots.internal;

import com.aliyun.common.auth.ServiceCredentials;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.openservices.ClientException;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.ots.OTSException;
import com.aliyun.openservices.ots.internal.OTSOperation;
import com.aliyun.openservices.ots.internal.OTSUtil;
import com.aliyun.openservices.ots.internal.model.GetTableMetaResult;
import com.aliyun.openservices.ots.internal.model.ListTableGroupResult;
import com.aliyun.openservices.ots.internal.model.ListTableResult;
import com.aliyun.openservices.ots.model.ColumnType;
import com.aliyun.openservices.ots.model.PartitionKeyType;
import com.aliyun.openservices.ots.model.PrimaryKeyType;
import com.aliyun.openservices.ots.model.TableMeta;
import com.aliyun.openservices.ots.model.ViewMeta;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OTSTableOperation
extends OTSOperation {
    private static final String ACTION_CREATETABLEGROUP = "CreateTableGroup";
    private static final String ACTION_LISTTABLEGROUP = "ListTableGroup";
    private static final String ACTION_DELETETABLEGROUP = "DeleteTableGroup";
    private static final String ACTION_CREATETABLE = "CreateTable";
    private static final String ACTION_GETTABLEMETA = "GetTableMeta";
    private static final String ACTION_LISTTABLE = "ListTable";
    private static final String ACTION_DELETETABLE = "DeleteTable";

    public OTSTableOperation(URI endpoint, ServiceClient client, ServiceCredentials credentials) {
        super(endpoint, client, credentials);
    }

    public void createTableGroup(String tableGroupName, PartitionKeyType pkType) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableGroupName, "tableGroupName");
        OTSUtil.ensureNameValid(tableGroupName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TableGroupName", tableGroupName);
        params.put("PartitionKeyType", pkType.toString());
        this.invokeNoResult(ACTION_CREATETABLEGROUP, HttpMethod.GET, params);
    }

    public List<String> listTableGroups() throws OTSException, ClientException {
        ListTableGroupResult result = (ListTableGroupResult)this.invoke(ACTION_LISTTABLEGROUP, HttpMethod.GET, null, ListTableGroupResult.class);
        ArrayList<String> names = new ArrayList<String>();
        if (result.TableGroupNames != null && result.TableGroupNames.TableGroupNames != null) {
            names.addAll(result.TableGroupNames.TableGroupNames);
        }
        return names;
    }

    public void deleteTableGroup(String tableGroupName) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableGroupName, "tableGroupName");
        OTSUtil.ensureNameValid(tableGroupName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TableGroupName", tableGroupName);
        this.invokeNoResult(ACTION_DELETETABLEGROUP, HttpMethod.GET, params);
    }

    public void createTable(TableMeta tableMeta) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableMeta, "tableMeta");
        Map<String, String> params = this.getRequestParameters(tableMeta);
        this.invokeNoResult(ACTION_CREATETABLE, HttpMethod.GET, params);
    }

    private Map<String, String> getRequestParameters(TableMeta tableMeta) {
        assert (OTSUtil.nameValid(tableMeta.getTableName()));
        if (tableMeta.getPrimaryKeys().size() == 0) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("TableMetaHasNoPK"));
        }
        if (tableMeta.getPagingKeyLen() >= tableMeta.getPrimaryKeys().size()) {
            throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("PagingLenNoLessThanPKCount"));
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("TableName", tableMeta.getTableName());
        int pkIndex = 1;
        for (Map.Entry<String, PrimaryKeyType> pk : tableMeta.getPrimaryKeys().entrySet()) {
            assert (OTSUtil.nameValid(pk.getKey()));
            String pre = String.format("PK.%d.", pkIndex++);
            params.put(pre + "Name", pk.getKey());
            params.put(pre + "Type", pk.getValue().toString());
        }
        if (tableMeta.getPagingKeyLen() > 0) {
            params.put("PagingKeyLen", Integer.toString(tableMeta.getPagingKeyLen()));
        }
        int viewIndex = 1;
        for (ViewMeta viewMeta : tableMeta.getViews()) {
            assert (OTSUtil.nameValid(viewMeta.getViewName()));
            if (viewMeta.getPrimaryKeys().size() == 0) {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("ViewMetaHasNoPK"));
            }
            if (viewMeta.getPagingKeyLen() >= viewMeta.getPrimaryKeys().size()) {
                throw new IllegalArgumentException(OTSUtil.OTS_RESOURCE_MANAGER.getString("PagingLenNoLessThanPKCount"));
            }
            String viewPre = String.format("View.%d.", viewIndex++);
            params.put(viewPre + "Name", viewMeta.getViewName());
            int viewPKIndex = 1;
            for (Map.Entry<String, PrimaryKeyType> vpk : viewMeta.getPrimaryKeys().entrySet()) {
                assert (OTSUtil.nameValid(vpk.getKey()));
                String pre = String.format("%sPK.%d.", viewPre, viewPKIndex++);
                params.put(pre + "Name", vpk.getKey());
                params.put(pre + "Type", vpk.getValue().toString());
            }
            int viewColIndex = 1;
            for (Map.Entry<String, ColumnType> col : viewMeta.getAttributeColumns().entrySet()) {
                assert (OTSUtil.nameValid(col.getKey()));
                String pre = String.format("%sColumn.%d.", viewPre, viewColIndex++);
                params.put(pre + "Name", col.getKey());
                params.put(pre + "Type", col.getValue().toString());
            }
            if (viewMeta.getPagingKeyLen() <= 0) continue;
            params.put(viewPre + "PagingKeyLen", Integer.toString(viewMeta.getPagingKeyLen()));
        }
        String tblGpName = tableMeta.getTableGroupName();
        if (tblGpName != null && tblGpName.length() > 0) {
            assert (OTSUtil.nameValid(tblGpName));
            params.put("TableGroupName", tblGpName);
        }
        return params;
    }

    public TableMeta getTableMeta(String tableName) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TableName", tableName);
        GetTableMetaResult result = (GetTableMetaResult)this.invoke(ACTION_GETTABLEMETA, HttpMethod.GET, params, GetTableMetaResult.class);
        return result.TableMeta;
    }

    public List<String> listTables() throws OTSException, ClientException {
        ListTableResult result = (ListTableResult)this.invoke(ACTION_LISTTABLE, HttpMethod.GET, null, ListTableResult.class);
        ArrayList<String> names = new ArrayList<String>();
        if (result.TableNames != null && result.TableNames.TableNames != null) {
            names.addAll(result.TableNames.TableNames);
        }
        return names;
    }

    public void deleteTable(String tableName) throws OTSException, ClientException {
        CodingUtils.assertParameterNotNull(tableName, "tableName");
        OTSUtil.ensureNameValid(tableName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TableName", tableName);
        this.invokeNoResult(ACTION_DELETETABLE, HttpMethod.GET, params);
    }
}

