/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.oss.internal;

import com.aliyun.common.comm.RequestMessage;
import com.aliyun.common.utils.CodingUtils;
import com.aliyun.common.utils.DateUtil;
import com.aliyun.openservices.HttpMethod;
import com.aliyun.openservices.oss.internal.OSSUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class OSSRequestMessageBuilder {
    private URI endpoint;
    private HttpMethod method = HttpMethod.GET;
    private String bucket;
    private String key;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private InputStream inputInstream;
    private long inputSize = 0L;

    public URI getEndpoint() {
        return this.endpoint;
    }

    public OSSRequestMessageBuilder setEndpoint(URI endpoint) {
        CodingUtils.assertParameterNotNull(endpoint, "endpoint");
        this.endpoint = endpoint;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public OSSRequestMessageBuilder setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public String getBucket() {
        return this.bucket;
    }

    public OSSRequestMessageBuilder setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public OSSRequestMessageBuilder setKey(String key) {
        this.key = key;
        return this;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public OSSRequestMessageBuilder setHeaders(Map<String, String> headers) {
        CodingUtils.assertParameterNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public OSSRequestMessageBuilder addHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public OSSRequestMessageBuilder setParameters(Map<String, String> parameters) {
        CodingUtils.assertParameterNotNull(parameters, "parameters");
        this.parameters = parameters;
        return this;
    }

    public OSSRequestMessageBuilder addParameter(String key, String value) {
        this.parameters.put(key, value);
        return this;
    }

    public InputStream getInputStream() {
        return this.inputInstream;
    }

    public OSSRequestMessageBuilder setInputStream(InputStream inputStream) {
        this.inputInstream = inputStream;
        return this;
    }

    public long getInputSize() {
        return this.inputSize;
    }

    public OSSRequestMessageBuilder setInputSize(long inputSize) {
        this.inputSize = inputSize;
        return this;
    }

    public RequestMessage build() {
        CodingUtils.assertParameterNotNull(this.endpoint, "endpoint");
        assert (0x140000000L >= this.inputSize);
        HashMap<String, String> sentHeaders = new HashMap<String, String>(this.headers);
        LinkedHashMap<String, String> sentParameters = new LinkedHashMap<String, String>(this.parameters);
        sentHeaders.put("Date", DateUtil.formatRfc822Date(new Date()));
        if (sentHeaders.get("Content-Type") == null) {
            sentHeaders.put("Content-Type", "");
        }
        RequestMessage request = new RequestMessage();
        request.setEndpoint(this.endpoint);
        request.setHeaders(sentHeaders);
        request.setParameters(sentParameters);
        request.setMethod(this.method);
        request.setResourcePath(OSSUtils.makeResourcePath(this.bucket, this.key));
        request.setContent(this.inputInstream);
        request.setContentLength(this.inputSize);
        return request;
    }
}

