/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.common.comm;

import com.aliyun.common.comm.ExecutionContext;
import com.aliyun.common.comm.HttpFactory;
import com.aliyun.common.comm.ResponseMessage;
import com.aliyun.common.comm.ServiceClient;
import com.aliyun.common.utils.HttpUtil;
import com.aliyun.openservices.ClientConfiguration;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;

public class DefaultServiceClient
extends ServiceClient {
    private HttpClient httpClient;

    public DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.httpClient = new HttpFactory().createHttpClient(config);
    }

    @Override
    public ResponseMessage sendRequestCore(ServiceClient.Request request, ExecutionContext context) throws IOException {
        assert (request != null && context != null);
        this.httpClient.getConnectionManager().closeIdleConnections(30L, TimeUnit.SECONDS);
        HttpRequestBase httpRequest = new HttpFactory().createHttpRequest(request, context);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpRequest);
        ResponseMessage result = new ResponseMessage();
        result.setUrl(request.getUri());
        if (response.getStatusLine() != null) {
            result.setStatusCode(response.getStatusLine().getStatusCode());
        }
        if (response.getEntity() != null) {
            result.setContent(response.getEntity().getContent());
        }
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> resultHeaders = new HashMap<String, String>();
        for (int i = 0; i < headers.length; ++i) {
            Header h = headers[i];
            resultHeaders.put(h.getName(), h.getValue());
        }
        HttpUtil.convertHeaderCharsetFromIso88591(resultHeaders);
        result.setHeaders(resultHeaders);
        return result;
    }
}

