/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.method;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheInvokeException;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.RefreshCache;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import com.alicp.jetcache.anno.method.ClassUtil;
import com.alicp.jetcache.anno.method.ExpressionUtil;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.anno.support.CachedAnnoConfig;
import com.alicp.jetcache.anno.support.ConfigMap;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CacheLoadEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(CacheHandler.class);
    private Object src;
    private Supplier<CacheInvokeContext> contextSupplier;
    private String[] hiddenPackages;
    private ConfigMap configMap;

    public CacheHandler(Object src, ConfigMap configMap, Supplier<CacheInvokeContext> contextSupplier, String[] hiddenPackages) {
        this.src = src;
        this.configMap = configMap;
        this.contextSupplier = contextSupplier;
        this.hiddenPackages = hiddenPackages;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CacheInvokeContext context = null;
        String sig = ClassUtil.getMethodSig(method);
        CacheInvokeConfig cac = this.configMap.getByMethodInfo(sig);
        if (cac != null) {
            context = this.contextSupplier.get();
            context.setCacheInvokeConfig(cac);
        }
        if (context == null) {
            return method.invoke(this.src, args);
        }
        context.setInvoker(() -> method.invoke(this.src, args));
        context.setHiddenPackages(this.hiddenPackages);
        context.setArgs(args);
        context.setMethod(method);
        return CacheHandler.invoke(context);
    }

    public static Object invoke(CacheInvokeContext context) throws Throwable {
        if (context.getCacheInvokeConfig().isEnableCacheContext()) {
            try {
                CacheContextSupport._enable();
                Object object = CacheHandler.doInvoke(context);
                return object;
            }
            finally {
                CacheContextSupport._disable();
            }
        }
        return CacheHandler.doInvoke(context);
    }

    private static Object doInvoke(CacheInvokeContext context) throws Throwable {
        CacheInvokeConfig cic = context.getCacheInvokeConfig();
        CachedAnnoConfig cachedConfig = cic.getCachedAnnoConfig();
        if (cachedConfig != null && (cachedConfig.isEnabled() || CacheContextSupport._isEnabled())) {
            return CacheHandler.invokeWithCached(context);
        }
        if (cic.getInvalidateAnnoConfig() != null || cic.getUpdateAnnoConfig() != null) {
            return CacheHandler.invokeWithInvalidateOrUpdate(context);
        }
        return CacheHandler.invokeOrigin(context);
    }

    private static Object invokeWithInvalidateOrUpdate(CacheInvokeContext context) throws Throwable {
        Object key;
        boolean condition;
        Cache cache;
        Object originResult = CacheHandler.invokeOrigin(context);
        CacheInvokeConfig cic = context.getCacheInvokeConfig();
        if (cic.getInvalidateAnnoConfig() != null) {
            cache = context.getCacheFunction().apply(context, cic.getInvalidateAnnoConfig());
            condition = ExpressionUtil.evalCondition(context, cic.getInvalidateAnnoConfig());
            if (cache != null && condition && (key = ExpressionUtil.evalKey(context, cic.getInvalidateAnnoConfig())) != null) {
                cache.remove(key);
            }
        }
        if (cic.getUpdateAnnoConfig() != null) {
            cache = context.getCacheFunction().apply(context, cic.getUpdateAnnoConfig());
            condition = ExpressionUtil.evalCondition(context, cic.getUpdateAnnoConfig());
            if (cache != null && condition) {
                key = ExpressionUtil.evalKey(context, cic.getUpdateAnnoConfig());
                Object value = ExpressionUtil.evalValue(context, cic.getUpdateAnnoConfig());
                if (key != null) {
                    cache.put(key, value);
                }
            }
        }
        return originResult;
    }

    private static Object invokeWithCached(CacheInvokeContext context) throws Throwable {
        CacheInvokeConfig cic = context.getCacheInvokeConfig();
        CachedAnnoConfig cac = cic.getCachedAnnoConfig();
        Cache cache = context.getCacheFunction().apply(context, cac);
        if (cache == null) {
            logger.error("no cache with name: " + context.getMethod());
            return CacheHandler.invokeOrigin(context);
        }
        Object key = ExpressionUtil.evalKey(context, cic.getCachedAnnoConfig());
        if (key == null) {
            return CacheHandler.loadAndCount(context, cache, key);
        }
        if (!ExpressionUtil.evalCondition(context, cic.getCachedAnnoConfig())) {
            return CacheHandler.loadAndCount(context, cache, key);
        }
        try {
            Object result = cache.computeIfAbsent(key, k -> {
                try {
                    return CacheHandler.invokeOrigin(context);
                }
                catch (Throwable e) {
                    throw new CacheInvokeException(e.getMessage(), e);
                }
            });
            if (cache instanceof CacheHandlerRefreshCache) {
                ((CacheHandlerRefreshCache)cache).addOrUpdateRefreshTask(key, unusedKey -> CacheHandler.invokeOrigin(context));
            }
            return result;
        }
        catch (CacheInvokeException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadAndCount(CacheInvokeContext context, Cache cache, Object key) throws Throwable {
        long t = System.currentTimeMillis();
        Object v = null;
        boolean success = false;
        try {
            v = CacheHandler.invokeOrigin(context);
            success = true;
        }
        finally {
            t = System.currentTimeMillis() - t;
            CacheLoadEvent event = new CacheLoadEvent(cache, t, key, v, success);
            while (cache instanceof ProxyCache) {
                cache = ((ProxyCache)cache).getTargetCache();
            }
            if (cache instanceof AbstractCache) {
                ((AbstractCache)cache).notify((CacheEvent)event);
            }
        }
        return v;
    }

    private static Object invokeOrigin(CacheInvokeContext context) throws Throwable {
        return context.getInvoker().invoke();
    }

    public static class CacheHandlerRefreshCache<K, V>
    extends RefreshCache<K, V> {
        public CacheHandlerRefreshCache(Cache cache) {
            super(cache);
        }

        public void addOrUpdateRefreshTask(K key, CacheLoader<K, V> loader) {
            super.addOrUpdateRefreshTask(key, loader);
        }
    }

    private static class CacheContextSupport
    extends CacheContext {
        public CacheContextSupport() {
            super(null);
        }

        static void _enable() {
            CacheContextSupport.enable();
        }

        static void _disable() {
            CacheContextSupport.disable();
        }

        static boolean _isEnabled() {
            return CacheContextSupport.isEnabled();
        }
    }
}

