/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.field;

import com.alicp.jetcache.AutoReleaseLock;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheResult;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.RefreshPolicy;
import com.alicp.jetcache.anno.CachePenetrationProtect;
import com.alicp.jetcache.anno.CacheRefresh;
import com.alicp.jetcache.anno.CreateCache;
import com.alicp.jetcache.anno.method.CacheConfigUtil;
import com.alicp.jetcache.anno.support.CacheNameGenerator;
import com.alicp.jetcache.anno.support.CachedAnnoConfig;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.anno.support.PenetrationProtectConfig;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

class LazyInitCache
implements ProxyCache {
    private boolean inited;
    private Cache cache;
    private ConfigurableListableBeanFactory beanFactory;
    private CreateCache ann;
    private Field field;
    private RefreshPolicy refreshPolicy;
    private PenetrationProtectConfig protectConfig;

    public LazyInitCache(ConfigurableListableBeanFactory beanFactory, CreateCache ann, Field field) {
        CachePenetrationProtect penetrateProtect;
        this.beanFactory = beanFactory;
        this.ann = ann;
        this.field = field;
        CacheRefresh cr = field.getAnnotation(CacheRefresh.class);
        if (cr != null) {
            this.refreshPolicy = CacheConfigUtil.parseRefreshPolicy(cr);
        }
        if ((penetrateProtect = field.getAnnotation(CachePenetrationProtect.class)) != null) {
            this.protectConfig = new PenetrationProtectConfig();
            this.protectConfig.setPenetrationProtect(penetrateProtect.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInit() {
        if (!this.inited) {
            LazyInitCache lazyInitCache = this;
            synchronized (lazyInitCache) {
                if (!this.inited) {
                    this.init();
                    this.inited = true;
                }
            }
        }
    }

    public Cache getTargetCache() {
        this.checkInit();
        return this.cache;
    }

    private void init() {
        if (this.inited) {
            throw new IllegalStateException();
        }
        GlobalCacheConfig globalCacheConfig = (GlobalCacheConfig)this.beanFactory.getBean(GlobalCacheConfig.class);
        CachedAnnoConfig cac = new CachedAnnoConfig();
        cac.setArea(this.ann.area());
        cac.setName(this.ann.name());
        cac.setTimeUnit(this.ann.timeUnit());
        cac.setExpire(this.ann.expire());
        cac.setLocalExpire(this.ann.localExpire());
        cac.setCacheType(this.ann.cacheType());
        cac.setLocalLimit(this.ann.localLimit());
        cac.setSerialPolicy(this.ann.serialPolicy());
        cac.setKeyConvertor(this.ann.keyConvertor());
        cac.setRefreshPolicy(this.refreshPolicy);
        cac.setPenetrationProtectConfig(this.protectConfig);
        String cacheName = cac.getName();
        if ("$$undefined$$".equalsIgnoreCase(cacheName)) {
            String[] hiddenPackages = globalCacheConfig.getHiddenPackages();
            CacheNameGenerator g = globalCacheConfig.getConfigProvider().createCacheNameGenerator(hiddenPackages);
            cacheName = g.generateCacheName(this.field);
        }
        this.cache = globalCacheConfig.getCacheContext().__createOrGetCache(cac, this.ann.area(), cacheName);
    }

    public CacheConfig config() {
        this.checkInit();
        return this.cache.config();
    }

    public Object get(Object key) {
        this.checkInit();
        return this.cache.get(key);
    }

    public Map getAll(Set keys) {
        this.checkInit();
        return this.cache.getAll(keys);
    }

    public CacheGetResult GET(Object key) {
        this.checkInit();
        return this.cache.GET(key);
    }

    public MultiGetResult GET_ALL(Set keys) {
        this.checkInit();
        return this.cache.GET_ALL(keys);
    }

    public Object computeIfAbsent(Object key, Function loader) {
        this.checkInit();
        return this.cache.computeIfAbsent(key, loader);
    }

    public Object computeIfAbsent(Object key, Function loader, boolean cacheNullWhenLoaderReturnNull) {
        this.checkInit();
        return this.cache.computeIfAbsent(key, loader, cacheNullWhenLoaderReturnNull);
    }

    public Object computeIfAbsent(Object key, Function loader, boolean cacheNullWhenLoaderReturnNull, long expireAfterWrite, TimeUnit timeUnit) {
        this.checkInit();
        return this.cache.computeIfAbsent(key, loader, cacheNullWhenLoaderReturnNull, expireAfterWrite, timeUnit);
    }

    public void put(Object key, Object value) {
        this.checkInit();
        this.cache.put(key, value);
    }

    public void putAll(Map map) {
        this.checkInit();
        this.cache.putAll(map);
    }

    public void put(Object key, Object value, long expireAfterWrite, TimeUnit timeUnit) {
        this.checkInit();
        this.cache.put(key, value, expireAfterWrite, timeUnit);
    }

    public CacheResult PUT(Object key, Object value) {
        this.checkInit();
        return this.cache.PUT(key, value);
    }

    public CacheResult PUT(Object key, Object value, long expireAfterWrite, TimeUnit timeUnit) {
        this.checkInit();
        return this.cache.PUT(key, value, expireAfterWrite, timeUnit);
    }

    public void putAll(Map map, long expireAfterWrite, TimeUnit timeUnit) {
        this.checkInit();
        this.cache.putAll(map, expireAfterWrite, timeUnit);
    }

    public CacheResult PUT_ALL(Map map) {
        this.checkInit();
        return this.cache.PUT_ALL(map);
    }

    public CacheResult PUT_ALL(Map map, long expireAfterWrite, TimeUnit timeUnit) {
        this.checkInit();
        return this.cache.PUT_ALL(map, expireAfterWrite, timeUnit);
    }

    public boolean remove(Object key) {
        this.checkInit();
        return this.cache.remove(key);
    }

    public void removeAll(Set keys) {
        this.checkInit();
        this.cache.removeAll(keys);
    }

    public Object unwrap(Class clazz) {
        this.checkInit();
        return this.cache.unwrap(clazz);
    }

    public CacheResult REMOVE(Object key) {
        this.checkInit();
        return this.cache.REMOVE(key);
    }

    public CacheResult REMOVE_ALL(Set keys) {
        this.checkInit();
        return this.cache.REMOVE_ALL(keys);
    }

    public AutoReleaseLock tryLock(Object key, long expire, TimeUnit timeUnit) {
        this.checkInit();
        return this.cache.tryLock(key, expire, timeUnit);
    }

    public boolean tryLockAndRun(Object key, long expire, TimeUnit timeUnit, Runnable action) {
        this.checkInit();
        return this.cache.tryLockAndRun(key, expire, timeUnit, action);
    }

    public boolean putIfAbsent(Object key, Object value) {
        this.checkInit();
        return this.cache.putIfAbsent(key, value);
    }

    public CacheResult PUT_IF_ABSENT(Object key, Object value, long expireAfterWrite, TimeUnit timeUnit) {
        this.checkInit();
        return this.cache.PUT_IF_ABSENT(key, value, expireAfterWrite, timeUnit);
    }
}

