/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.aop;

import com.alicp.jetcache.anno.aop.CachePointcut;
import com.alicp.jetcache.anno.method.CacheHandler;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import com.alicp.jetcache.anno.support.ConfigMap;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JetCacheInterceptor
implements MethodInterceptor,
ApplicationContextAware {
    private ConfigMap cacheConfigMap;
    private ApplicationContext applicationContext;
    GlobalCacheConfig globalCacheConfig;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object obj = invocation.getThis();
        CacheInvokeConfig cac = null;
        if (obj != null) {
            String key = CachePointcut.getKey(method, obj.getClass());
            cac = this.cacheConfigMap.getByMethodInfo(key);
        }
        if (cac == null || cac == CacheInvokeConfig.getNoCacheInvokeConfigInstance()) {
            return invocation.proceed();
        }
        if (this.globalCacheConfig == null) {
            this.globalCacheConfig = (GlobalCacheConfig)this.applicationContext.getBean(GlobalCacheConfig.class);
        }
        CacheInvokeContext context = this.globalCacheConfig.getCacheContext().createCacheInvokeContext(this.cacheConfigMap);
        context.setTargetObject(invocation.getThis());
        context.setInvoker(() -> ((MethodInvocation)invocation).proceed());
        context.setMethod(method);
        context.setArgs(invocation.getArguments());
        context.setCacheInvokeConfig(cac);
        context.setHiddenPackages(this.globalCacheConfig.getHiddenPackages());
        return CacheHandler.invoke(context);
    }

    public void setCacheConfigMap(ConfigMap cacheConfigMap) {
        this.cacheConfigMap = cacheConfigMap;
    }
}

