/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.rpc;

import com.alibaba.fescar.core.rpc.netty.NettyPoolKey;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcContext.class);
    private NettyPoolKey.TransactionRole clientRole;
    private String version;
    private String applicationId;
    private String transactionServiceGroup;
    private String clientId;
    private Channel channel;
    private Set<String> resourceSets;
    private ConcurrentMap<Channel, RpcContext> clientIDHolderMap;
    private ConcurrentMap<Integer, RpcContext> clientTMHolderMap;
    private ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>> clientRMHolderMap;

    public void release() {
        Integer clientPort = RpcContext.getClientPortFromChannel(this.channel);
        if (this.clientIDHolderMap != null) {
            this.clientIDHolderMap = null;
        }
        if (this.clientRole == NettyPoolKey.TransactionRole.TMROLE && this.clientTMHolderMap != null) {
            this.clientTMHolderMap.remove(clientPort);
            this.clientTMHolderMap = null;
        }
        if (this.clientRole == NettyPoolKey.TransactionRole.RMROLE && this.clientRMHolderMap != null) {
            for (Map portMap : this.clientRMHolderMap.values()) {
                portMap.remove(clientPort);
            }
            this.clientRMHolderMap = null;
        }
        if (null != this.resourceSets) {
            this.resourceSets.clear();
        }
    }

    public void holdInClientChannels(ConcurrentMap<Integer, RpcContext> clientTMHolderMap) {
        if (this.clientTMHolderMap != null) {
            throw new IllegalStateException();
        }
        this.clientTMHolderMap = clientTMHolderMap;
        Integer clientPort = RpcContext.getClientPortFromChannel(this.channel);
        this.clientTMHolderMap.put(clientPort, this);
    }

    public void holdInIdentifiedChannels(ConcurrentMap<Channel, RpcContext> clientIDHolderMap) {
        if (this.clientIDHolderMap != null) {
            throw new IllegalStateException();
        }
        this.clientIDHolderMap = clientIDHolderMap;
        this.clientIDHolderMap.put(this.channel, this);
    }

    public void holdInResourceManagerChannels(String resourceId, ConcurrentMap<Integer, RpcContext> portMap) {
        if (null == this.clientRMHolderMap) {
            this.clientRMHolderMap = new ConcurrentHashMap<String, ConcurrentMap<Integer, RpcContext>>();
        }
        Integer clientPort = RpcContext.getClientPortFromChannel(this.channel);
        portMap.put(clientPort, this);
        this.clientRMHolderMap.put(resourceId, portMap);
    }

    public void holdInResourceManagerChannels(String resourceId, Integer clientPort) {
        if (null == this.clientRMHolderMap) {
            this.clientRMHolderMap = new ConcurrentHashMap<String, ConcurrentMap<Integer, RpcContext>>();
        }
        this.clientRMHolderMap.putIfAbsent(resourceId, new ConcurrentHashMap());
        ConcurrentMap portMap = (ConcurrentMap)this.clientRMHolderMap.get(resourceId);
        portMap.put(clientPort, this);
    }

    public ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>> getClientRMHolderMap() {
        return this.clientRMHolderMap;
    }

    public Map<Integer, RpcContext> getPortMap(String resourceId) {
        return (Map)this.clientRMHolderMap.get(resourceId);
    }

    public String getClientId() {
        return this.clientId;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    public void setTransactionServiceGroup(String transactionServiceGroup) {
        this.transactionServiceGroup = transactionServiceGroup;
    }

    public NettyPoolKey.TransactionRole getClientRole() {
        return this.clientRole;
    }

    public void setClientRole(NettyPoolKey.TransactionRole clientRole) {
        this.clientRole = clientRole;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private static String getAddressFromChannel(Channel channel) {
        SocketAddress socketAddress = channel.remoteAddress();
        String address = socketAddress.toString();
        if (socketAddress.toString().indexOf("/") == 0) {
            address = socketAddress.toString().substring("/".length());
        }
        return address;
    }

    private static Integer getClientPortFromChannel(Channel channel) {
        String address = RpcContext.getAddressFromChannel(channel);
        Integer port = 0;
        try {
            if (address.contains(":")) {
                port = Integer.parseInt(address.substring(address.lastIndexOf(":") + 1));
            }
        }
        catch (NumberFormatException exx) {
            LOGGER.error(exx.getMessage());
        }
        return port;
    }

    public Set<String> getResourceSets() {
        return this.resourceSets;
    }

    public void setResourceSets(Set<String> resourceSets) {
        this.resourceSets = resourceSets;
    }

    public void addResource(String resource) {
        if (null == resource) {
            this.resourceSets = new HashSet<String>();
        }
        this.resourceSets.add(resource);
    }

    public void addResources(Set<String> resource) {
        if (null == resource) {
            return;
        }
        if (null == this.resourceSets) {
            this.resourceSets = new HashSet<String>();
        }
        this.resourceSets.addAll(resource);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String toString() {
        return "RpcContext{applicationId='" + this.applicationId + '\'' + ", transactionServiceGroup='" + this.transactionServiceGroup + '\'' + ", clientId='" + this.clientId + '\'' + ", channel=" + this.channel + ", resourceSets=" + this.resourceSets + '}';
    }
}

