/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.protocol.transaction;

import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionRequestToRM;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;

public abstract class AbstractBranchEndRequest
extends AbstractTransactionRequestToRM {
    private static final long serialVersionUID = 5083828939317068713L;
    protected String xid;
    protected long branchId;
    protected BranchType branchType = BranchType.AT;
    protected String resourceId;
    protected String applicationData;

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public long getBranchId() {
        return this.branchId;
    }

    public void setBranchId(long branchId) {
        this.branchId = branchId;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public byte[] encode() {
        byte[] bs;
        byte[] applicationDataBytes = null;
        if (this.applicationData != null && (applicationDataBytes = this.applicationData.getBytes(UTF8)).length > 512) {
            this.byteBuffer = ByteBuffer.allocate(applicationDataBytes.length + 1024);
        }
        if (this.xid != null) {
            bs = this.xid.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        this.byteBuffer.putLong(this.branchId);
        this.byteBuffer.put((byte)this.branchType.ordinal());
        if (this.resourceId != null) {
            bs = this.resourceId.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.applicationData != null) {
            this.byteBuffer.putInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                this.byteBuffer.put(applicationDataBytes);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        int applicationDataLen;
        int leftLen = in.readableBytes();
        boolean read = false;
        short xidLen = in.readShort();
        if (xidLen > 0) {
            if (leftLen < xidLen) {
                return false;
            }
            byte[] bs = new byte[xidLen];
            in.readBytes(bs);
            this.setXid(new String(bs, UTF8));
            leftLen -= xidLen;
        }
        this.branchId = in.readLong();
        leftLen -= 8;
        this.branchType = BranchType.get(in.readByte());
        --leftLen;
        short resourceIdLen = in.readShort();
        if (resourceIdLen > 0) {
            if (leftLen < resourceIdLen) {
                return false;
            }
            byte[] bs = new byte[resourceIdLen];
            in.readBytes(bs);
            this.setResourceId(new String(bs, UTF8));
            leftLen -= resourceIdLen;
        }
        if ((applicationDataLen = in.readInt()) > 0) {
            if (leftLen < applicationDataLen) {
                return false;
            }
            byte[] bs = new byte[applicationDataLen];
            in.readBytes(bs);
            this.setApplicationData(new String(bs, UTF8));
            leftLen -= applicationDataLen;
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("xid=");
        result.append(this.xid);
        result.append(",");
        result.append("branchId=");
        result.append(this.branchId);
        result.append(",");
        result.append("branchType=");
        result.append((Object)this.branchType);
        result.append(",");
        result.append("resourceId=");
        result.append(this.resourceId);
        result.append(",");
        result.append("applicationData=");
        result.append(this.applicationData);
        return result.toString();
    }
}

