/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.protocol;

import com.alibaba.fescar.core.protocol.AbstractResultMessage;
import io.netty.buffer.ByteBuf;

public abstract class AbstractIdentifyResponse
extends AbstractResultMessage {
    private String version = "0.4.1";
    private String extraData;
    private boolean identified;

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public void setIdentified(boolean identified) {
        this.identified = identified;
    }

    @Override
    public void doEncode() {
        this.byteBuffer.put(this.identified ? (byte)1 : 0);
        if (this.version != null) {
            byte[] bs = this.version.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
    }

    @Override
    public boolean decode(ByteBuf in) {
        int i = in.readableBytes();
        if (i < 3) {
            return false;
        }
        i -= 3;
        this.identified = in.readByte() == 1;
        short len = in.readShort();
        if (len > 0) {
            if (i < len) {
                return false;
            }
            byte[] bs = new byte[len];
            in.readBytes(bs);
            this.setVersion(new String(bs, UTF8));
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("version=");
        result.append(String.valueOf(this.version));
        result.append(",");
        result.append("extraData=");
        result.append(String.valueOf(this.extraData));
        result.append(",");
        result.append("identified=");
        result.append(String.valueOf(this.identified));
        result.append(",");
        result.append("resultCode=");
        result.append(String.valueOf((Object)this.getResultCode()));
        result.append(",");
        result.append("msg=");
        result.append(String.valueOf(this.getMsg()));
        return result.toString();
    }
}

