/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.core.exception;

import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.core.protocol.ResultCode;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionRequest;
import com.alibaba.fescar.core.protocol.transaction.AbstractTransactionResponse;

public abstract class AbstractExceptionHandler {
    public void exceptionHandleTemplate(Callback callback, AbstractTransactionRequest request, AbstractTransactionResponse response) {
        try {
            callback.execute(request, response);
            response.setResultCode(ResultCode.Success);
        }
        catch (TransactionException tex) {
            response.setTransactionExceptionCode(tex.getCode());
            response.setResultCode(ResultCode.Failed);
            response.setMsg("TransactionException[" + tex.getMessage() + "]");
        }
        catch (RuntimeException rex) {
            response.setResultCode(ResultCode.Failed);
            response.setMsg("RuntimeException[" + rex.getMessage() + "]");
        }
    }

    public static interface Callback<T extends AbstractTransactionRequest, S extends AbstractTransactionResponse> {
        public void execute(T var1, S var2) throws TransactionException;
    }
}

