/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.util;

import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.exception.TMQClientException;
import com.alibaba.tmq.common.exception.TMQException;
import com.alibaba.tmq.common.util.RegularExpressionUtil;
import java.util.List;
import java.util.UUID;

public class IdAndKeyUtil
implements Constants {
    public static String acquireUniqueId() {
        return UUID.randomUUID().toString().toUpperCase().replace("-", "");
    }

    public static String acquireUniqueKey(String messageId, Message message) throws TMQException {
        if (StringUtil.isBlank(message.getMessageKey())) {
            return message.getTopic() + "@AND#" + messageId;
        }
        if (!RegularExpressionUtil.correctName(message.getMessageKey())) {
            throw new TMQClientException("messageKey can only contains a-z or A-Z or 0-9 or . or - or _ ");
        }
        return message.getTopic() + "@AND#" + message.getMessageKey();
    }

    public static void renderingMessageKey(String producerId, Message message) throws TMQException {
        message.setProducerId(producerId);
        if (StringUtil.isBlank(message.getMessageKey())) {
            message.setMessageKey(message.getTopic() + "@AND#" + message.getMessageId());
            return;
        }
        if (!RegularExpressionUtil.correctName(message.getMessageKey())) {
            throw new TMQClientException("messageKey can only contains a-z or A-Z or 0-9 or . or - or _ ");
        }
        message.setMessageKey(message.getTopic() + "@AND#" + message.getMessageKey());
    }

    public static void renderingMessageKey(String producerId, List<Message> messageList) throws TMQException {
        for (Message message : messageList) {
            IdAndKeyUtil.renderingMessageKey(producerId, message);
        }
    }
}

