/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.proxy;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.remoting.ClassKey;
import com.alibaba.tmq.common.domain.result.ResultCode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyService
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ProxyService.class);
    public static final Map<String, Class<?>> BASE_CLASS = new HashMap();
    private final Map<ClassKey, Method> methodCache = new ConcurrentHashMap<ClassKey, Method>();

    public static Class<?> getClass(String parameterTypeString) {
        Class<?> parameterTypeClass = BASE_CLASS.get(parameterTypeString);
        if (parameterTypeClass != null) {
            return parameterTypeClass;
        }
        try {
            return Class.forName(parameterTypeString);
        }
        catch (Throwable e) {
            logger.error("[ProxyService]: getClass error, parameterTypeString:" + parameterTypeString, e);
            return null;
        }
    }

    public <T> T proxyInterface(Class<T> interfaceClass, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, invocationHandler);
    }

    public <T> T newInstance(Class<T> classType) {
        try {
            return classType.newInstance();
        }
        catch (Throwable e) {
            logger.error("[ProxyService]: newInstance error, classType:" + classType.getName(), e);
            return null;
        }
    }

    public <T> T newInstance(String classType) {
        Class<?> type = null;
        try {
            type = Class.forName(classType);
        }
        catch (Throwable e) {
            logger.error("[ProxyService]: newInstance Class.forName error, classType:" + classType, e);
            return null;
        }
        try {
            return (T)type.newInstance();
        }
        catch (Throwable e) {
            logger.error("[ProxyService]: newInstance error, classType:" + classType, e);
            return null;
        }
    }

    public Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        Method method = this.getMethod(object, methodName, parameterTypes);
        if (null == method) {
            return ResultCode.NO_SUCH_METHOD;
        }
        Object result = null;
        try {
            method.setAccessible(true);
            result = method.invoke(object, arguments);
        }
        catch (Throwable e) {
            String info = "[invokeMethod]: error, methodName:" + methodName;
            logger.error(info, e);
            throw new RuntimeException(info, e);
        }
        return result;
    }

    private Method getMethod(Object object, String methodName, Class<?>[] parameterTypes) {
        ClassKey classKey = new ClassKey(object, methodName, parameterTypes);
        Method method = this.methodCache.get(classKey);
        if (method != null) {
            return method;
        }
        method = this.tryFindMethod(object, methodName, parameterTypes);
        if (method != null) {
            this.methodCache.put(classKey, method);
        }
        return method;
    }

    private Method tryFindMethod(Object object, String methodName, Class<?>[] parameterTypes) {
        Method method = null;
        try {
            method = object.getClass().getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Throwable e) {
            String info = "[tryFindMethod]: failed, methodName:" + methodName;
            logger.error(info, e);
            throw new RuntimeException(info, e);
        }
        return method;
    }

    static {
        BASE_CLASS.put("double", Double.TYPE);
        BASE_CLASS.put("long", Long.TYPE);
        BASE_CLASS.put("float", Float.TYPE);
        BASE_CLASS.put("int", Integer.TYPE);
        BASE_CLASS.put("short", Short.TYPE);
        BASE_CLASS.put("char", Character.TYPE);
        BASE_CLASS.put("byte", Byte.TYPE);
        BASE_CLASS.put("boolean", Boolean.TYPE);
        BASE_CLASS.put("void", Void.TYPE);
    }
}

