/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.zookeeper;

import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.util.ListUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Zookeeper
extends ClientContext
implements Constants {
    private static final Log logger = LogFactory.getLog(Zookeeper.class);

    public void init() throws InitException {
        this.initZkManager();
    }

    public void initZkManager() throws InitException {
    }

    public List<String> getServerListForProducer() {
        String ip = clientConfig.getLocalAddress();
        List<String> serverList = httpService.acquireServers(clientConfig.getDomainName(), clientConfig.getClusterId(), "producer", ip);
        if (ListUtil.isEmpty(serverList)) {
            return null;
        }
        this.checkIsolate(serverList);
        Collections.sort(serverList);
        return serverList;
    }

    public List<String> getbackupServerListForProducer() {
        if (StringUtil.isBlank(ClientContext.clientConfig.getBackupDomainName())) {
            return null;
        }
        String ip = clientConfig.getLocalAddress();
        List<String> serverList = httpService.acquireServers(clientConfig.getBackupDomainName(), clientConfig.getBackupClusterId(), "producer", ip);
        if (ListUtil.isEmpty(serverList)) {
            return null;
        }
        this.checkIsolate(serverList);
        Collections.sort(serverList);
        return serverList;
    }

    public List<String> getServerListForConsumer() {
        String ip = clientConfig.getLocalAddress();
        List<String> serverList = httpService.acquireServers(clientConfig.getDomainName(), clientConfig.getClusterId(), "consumer", ip);
        if (ListUtil.isEmpty(serverList)) {
            return null;
        }
        this.checkIsolate(serverList);
        Collections.sort(serverList);
        return serverList;
    }

    public List<String> getbackupServerListForConsumer() {
        if (StringUtil.isBlank(ClientContext.clientConfig.getBackupDomainName())) {
            return null;
        }
        String ip = clientConfig.getLocalAddress();
        List<String> serverList = httpService.acquireServers(clientConfig.getBackupDomainName(), clientConfig.getBackupClusterId(), "consumer", ip);
        if (ListUtil.isEmpty(serverList)) {
            return null;
        }
        this.checkIsolate(serverList);
        Collections.sort(serverList);
        return serverList;
    }

    private void checkIsolate(List<String> serverList) {
        if (serverList.size() == 1 && serverList.get(0).equals("1.2.3.4")) {
            if (!clientRemoting.isIsolated()) {
                logger.warn((Object)"[Zookeeper]: receive fake server, isolated!!!");
                clientRemoting.setIsolated(true);
            }
            serverList.clear();
        } else if (clientRemoting.isIsolated()) {
            logger.warn((Object)"[Zookeeper]: receive normal server and we are isolated before, remove isolation!!!");
            clientRemoting.setIsolated(false);
        }
    }
}

