/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore;

import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.Chunk;
import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.mvstore.MVMap;
import com.alibaba.dts.shade.org.h2.mvstore.MVStore;
import com.alibaba.dts.shade.org.h2.mvstore.WriteBuffer;
import com.alibaba.dts.shade.org.h2.mvstore.type.DataType;
import com.alibaba.dts.shade.org.h2.mvstore.type.StringDataType;
import com.alibaba.dts.shade.org.h2.store.fs.FilePath;
import com.alibaba.dts.shade.org.h2.store.fs.FileUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeMap;

public class MVStoreTool {
    public static void main(String ... args) {
        for (int i = 0; i < args.length; ++i) {
            String fileName;
            if ("-dump".equals(args[i])) {
                fileName = args[++i];
                MVStoreTool.dump(fileName, new PrintWriter(System.out), true);
                continue;
            }
            if ("-info".equals(args[i])) {
                fileName = args[++i];
                MVStoreTool.info(fileName, new PrintWriter(System.out));
                continue;
            }
            if ("-compact".equals(args[i])) {
                fileName = args[++i];
                MVStoreTool.compact(fileName, false);
                continue;
            }
            if (!"-compress".equals(args[i])) continue;
            fileName = args[++i];
            MVStoreTool.compact(fileName, true);
        }
    }

    public static void dump(String fileName, boolean details) {
        MVStoreTool.dump(fileName, new PrintWriter(System.out), details);
    }

    public static void info(String fileName) {
        MVStoreTool.info(fileName, new PrintWriter(System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String fileName, Writer writer, boolean details) {
        PrintWriter pw = new PrintWriter(writer, true);
        if (!FilePath.get(fileName).exists()) {
            pw.println("File not found: " + fileName);
            return;
        }
        long size = FileUtils.size(fileName);
        pw.printf("File %s, %d bytes, %d MB\n", fileName, size, size / 1024L / 1024L);
        FileChannel file = null;
        int blockSize = 4096;
        TreeMap<Integer, Long> mapSizesTotal = new TreeMap<Integer, Long>();
        long pageSizeTotal = 0L;
        try {
            file = FilePath.get(fileName).open("r");
            long fileSize = file.size();
            int len = Long.toHexString(fileSize).length();
            ByteBuffer block = ByteBuffer.allocate(4096);
            long pageCount = 0L;
            long pos = 0L;
            while (pos < fileSize) {
                block.rewind();
                DataUtils.readFully(file, pos, block);
                block.rewind();
                byte headerType = block.get();
                if (headerType == 72) {
                    String header = new String(block.array(), DataUtils.LATIN).trim();
                    pw.printf("%0" + len + "x fileHeader %s%n", pos, header);
                    pos += (long)blockSize;
                    continue;
                }
                if (headerType != 99) {
                    pos += (long)blockSize;
                    continue;
                }
                block.position(0);
                Chunk c = null;
                try {
                    c = Chunk.readChunkHeader(block, pos);
                }
                catch (IllegalStateException e) {
                    pos += (long)blockSize;
                    continue;
                }
                if (c.len <= 0) {
                    pos += (long)blockSize;
                    continue;
                }
                int length = c.len * 4096;
                pw.printf("%n%0" + len + "x chunkHeader %s%n", pos, c.toString());
                ByteBuffer chunk = ByteBuffer.allocate(length);
                DataUtils.readFully(file, pos, chunk);
                int p = block.position();
                pos += (long)length;
                int remaining = c.pageCount;
                pageCount += (long)c.pageCount;
                TreeMap<Integer, Integer> mapSizes = new TreeMap<Integer, Integer>();
                int pageSizeSum = 0;
                while (remaining > 0) {
                    long cp;
                    boolean node;
                    try {
                        chunk.position(p);
                    }
                    catch (IllegalArgumentException e) {
                        pw.printf("ERROR illegal position %d%n", p);
                        break;
                    }
                    int pageSize = chunk.getInt();
                    chunk.getShort();
                    int mapId = DataUtils.readVarInt(chunk);
                    int entries = DataUtils.readVarInt(chunk);
                    byte type = chunk.get();
                    boolean compressed = (type & 2) != 0;
                    boolean bl = node = (type & 1) != 0;
                    if (details) {
                        pw.printf("+%0" + len + "x %s, map %x, %d entries, %d bytes, maxLen %x%n", p, (node ? "node" : "leaf") + (compressed ? " compressed" : ""), mapId, node ? entries + 1 : entries, pageSize, DataUtils.getPageMaxLength(DataUtils.getPagePos(0, 0, pageSize, 0)));
                    }
                    p += pageSize;
                    Integer mapSize = (Integer)mapSizes.get(mapId);
                    if (mapSize == null) {
                        mapSize = 0;
                    }
                    mapSizes.put(mapId, mapSize + pageSize);
                    Long total = (Long)mapSizesTotal.get(mapId);
                    if (total == null) {
                        total = 0L;
                    }
                    mapSizesTotal.put(mapId, total + (long)pageSize);
                    pageSizeSum += pageSize;
                    pageSizeTotal += (long)pageSize;
                    --remaining;
                    long[] children = null;
                    long[] counts = null;
                    if (node) {
                        int i;
                        children = new long[entries + 1];
                        for (i = 0; i <= entries; ++i) {
                            children[i] = chunk.getLong();
                        }
                        counts = new long[entries + 1];
                        for (i = 0; i <= entries; ++i) {
                            long s;
                            counts[i] = s = DataUtils.readVarLong(chunk);
                        }
                    }
                    String[] keys = new String[entries];
                    if (mapId == 0 && details) {
                        int i;
                        int i2;
                        if (!compressed) {
                            for (i2 = 0; i2 < entries; ++i2) {
                                String k;
                                keys[i2] = k = StringDataType.INSTANCE.read(chunk);
                            }
                        }
                        if (node) {
                            for (i2 = 0; i2 < entries; ++i2) {
                                cp = children[i2];
                                pw.printf("    %d children < %s @ chunk %x +%0" + len + "x%n", counts[i2], keys[i2], DataUtils.getPageChunkId(cp), DataUtils.getPageOffset(cp));
                            }
                            long cp2 = children[entries];
                            pw.printf("    %d children >= %s @ chunk %x +%0" + len + "x%n", counts[entries], keys.length >= entries ? null : keys[entries], DataUtils.getPageChunkId(cp2), DataUtils.getPageOffset(cp2));
                            continue;
                        }
                        if (compressed) continue;
                        String[] values = new String[entries];
                        for (i = 0; i < entries; ++i) {
                            String v;
                            values[i] = v = StringDataType.INSTANCE.read(chunk);
                        }
                        for (i = 0; i < entries; ++i) {
                            pw.println("    " + keys[i] + " = " + values[i]);
                        }
                        continue;
                    }
                    if (!node || !details) continue;
                    for (int i = 0; i <= entries; ++i) {
                        cp = children[i];
                        pw.printf("    %d children @ chunk %x +%0" + len + "x%n", counts[i], DataUtils.getPageChunkId(cp), DataUtils.getPageOffset(cp));
                    }
                }
                pageSizeSum = Math.max(1, pageSizeSum);
                for (Integer mapId : mapSizes.keySet()) {
                    int percent = 100 * (Integer)mapSizes.get(mapId) / pageSizeSum;
                    pw.printf("map %x: %d bytes, %d%%%n", mapId, mapSizes.get(mapId), percent);
                }
                int footerPos = chunk.limit() - 128;
                try {
                    chunk.position(footerPos);
                    pw.printf("+%0" + len + "x chunkFooter %s%n", footerPos, new String(chunk.array(), chunk.position(), 128, DataUtils.LATIN).trim());
                }
                catch (IllegalArgumentException e) {
                    pw.printf("ERROR illegal footer position %d%n", footerPos);
                }
            }
            pw.printf("%n%0" + len + "x eof%n", fileSize);
            pw.printf("\n", new Object[0]);
            pageCount = Math.max(1L, pageCount);
            pw.printf("page size total: %d bytes, page count: %d, average page size: %d bytes\n", pageSizeTotal, pageCount, pageSizeTotal / pageCount);
            pageSizeTotal = Math.max(1L, pageSizeTotal);
            for (Integer mapId : mapSizesTotal.keySet()) {
                int percent = (int)(100L * (Long)mapSizesTotal.get(mapId) / pageSizeTotal);
                pw.printf("map %x: %d bytes, %d%%%n", mapId, mapSizesTotal.get(mapId), percent);
            }
        }
        catch (IOException e) {
            pw.println("ERROR: " + e);
            e.printStackTrace(pw);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {}
            }
        }
        pw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(String fileName, Writer writer) {
        PrintWriter pw = new PrintWriter(writer, true);
        if (!FilePath.get(fileName).exists()) {
            pw.println("File not found: " + fileName);
            return;
        }
        long fileLength = FileUtils.size(fileName);
        MVStore store = new MVStore.Builder().fileName(fileName).readOnly().open();
        try {
            MVMap<String, String> meta = store.getMetaMap();
            Map<String, Object> header = store.getStoreHeader();
            long fileCreated = DataUtils.readHexLong(header, "created", 0L);
            TreeMap<Integer, Chunk> chunks = new TreeMap<Integer, Chunk>();
            long chunkLength = 0L;
            long maxLength = 0L;
            long maxLengthLive = 0L;
            long maxLengthNotEmpty = 0L;
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                String k = entry.getKey();
                if (!k.startsWith("chunk.")) continue;
                Chunk c = Chunk.fromString(entry.getValue());
                chunks.put(c.id, c);
                chunkLength += (long)(c.len * 4096);
                maxLength += c.maxLen;
                maxLengthLive += c.maxLenLive;
                if (c.maxLenLive <= 0L) continue;
                maxLengthNotEmpty += c.maxLen;
            }
            pw.printf("Created: %s\n", MVStoreTool.formatTimestamp(fileCreated, fileCreated));
            pw.printf("Last modified: %s\n", MVStoreTool.formatTimestamp(FileUtils.lastModified(fileName), fileCreated));
            pw.printf("File length: %d\n", fileLength);
            pw.printf("The last chunk is not listed\n", new Object[0]);
            pw.printf("Chunk length: %d\n", chunkLength);
            pw.printf("Chunk count: %d\n", chunks.size());
            pw.printf("Used space: %d%%\n", MVStoreTool.getPercent(chunkLength, fileLength));
            pw.printf("Chunk fill rate: %d%%\n", maxLength == 0L ? 100 : MVStoreTool.getPercent(maxLengthLive, maxLength));
            pw.printf("Chunk fill rate excluding empty chunks: %d%%\n", maxLengthNotEmpty == 0L ? 100 : MVStoreTool.getPercent(maxLengthLive, maxLengthNotEmpty));
            for (Map.Entry<String, String> entry : chunks.entrySet()) {
                Chunk c = (Chunk)((Object)entry.getValue());
                long created = fileCreated + c.time;
                pw.printf("  Chunk %d: %s, %d%% used, %d blocks", c.id, MVStoreTool.formatTimestamp(created, fileCreated), MVStoreTool.getPercent(c.maxLenLive, c.maxLen), c.len);
                if (c.maxLenLive == 0L) {
                    pw.printf(", unused: %s", MVStoreTool.formatTimestamp(fileCreated + c.unused, fileCreated));
                }
                pw.printf("\n", new Object[0]);
            }
            pw.printf("\n", new Object[0]);
        }
        catch (Exception e) {
            pw.println("ERROR: " + e);
            e.printStackTrace(pw);
        }
        finally {
            store.close();
        }
        pw.flush();
    }

    private static String formatTimestamp(long t, long start) {
        String x = new Timestamp(t).toString();
        String s = x.substring(0, 19);
        s = s + " (+" + (t - start) / 1000L + " s)";
        return s;
    }

    private static int getPercent(long value, long max) {
        if (value == 0L) {
            return 0;
        }
        if (value == max) {
            return 100;
        }
        return (int)(1L + 98L * value / Math.max(1L, max));
    }

    public static void compact(String fileName, boolean compress) {
        String tempName = fileName + ".tempFile";
        FileUtils.delete(tempName);
        MVStoreTool.compact(fileName, tempName, compress);
        try {
            FileUtils.moveAtomicReplace(tempName, fileName);
        }
        catch (DbException e) {
            String newName = fileName + ".newFile";
            FileUtils.delete(newName);
            FileUtils.move(tempName, newName);
            FileUtils.delete(fileName);
            FileUtils.move(newName, fileName);
        }
    }

    public static void compactCleanUp(String fileName) {
        String newName;
        String tempName = fileName + ".tempFile";
        if (FileUtils.exists(tempName)) {
            FileUtils.delete(tempName);
        }
        if (FileUtils.exists(newName = fileName + ".newFile")) {
            if (FileUtils.exists(fileName)) {
                FileUtils.delete(newName);
            } else {
                FileUtils.move(newName, fileName);
            }
        }
    }

    public static void compact(String sourceFileName, String targetFileName, boolean compress) {
        MVStore source = new MVStore.Builder().fileName(sourceFileName).readOnly().open();
        FileUtils.delete(targetFileName);
        MVStore.Builder b = new MVStore.Builder().fileName(targetFileName);
        if (compress) {
            b.compress();
        }
        MVStore target = b.open();
        MVStoreTool.compact(source, target);
        target.close();
        source.close();
    }

    public static void compact(MVStore source, MVStore target) {
        MVMap<String, String> sourceMeta = source.getMetaMap();
        MVMap<String, String> targetMeta = target.getMetaMap();
        for (Map.Entry<String, String> m : sourceMeta.entrySet()) {
            String key = m.getKey();
            if (key.startsWith("chunk.") || key.startsWith("map.") || key.startsWith("name.") || key.startsWith("root.")) continue;
            targetMeta.put(key, m.getValue());
        }
        for (String mapName : source.getMapNames()) {
            MVMap.Builder mp = new MVMap.Builder().keyType(new GenericDataType()).valueType(new GenericDataType());
            Object sourceMap = source.openMap(mapName, mp);
            Object targetMap = target.openMap(mapName, mp);
            ((MVMap)targetMap).copyFrom(sourceMap);
        }
    }

    static class GenericDataType
    implements DataType {
        GenericDataType() {
        }

        @Override
        public int compare(Object a, Object b) {
            throw DataUtils.newUnsupportedOperationException("Can not compare");
        }

        @Override
        public int getMemory(Object obj) {
            return obj == null ? 0 : ((byte[])obj).length * 8;
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (obj != null) {
                buff.put((byte[])obj);
            }
        }

        @Override
        public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
            for (Object o : obj) {
                this.write(buff, o);
            }
        }

        @Override
        public Object read(ByteBuffer buff) {
            int len = buff.remaining();
            if (len == 0) {
                return null;
            }
            byte[] data = new byte[len];
            buff.get(data);
            return data;
        }

        @Override
        public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
            for (int i = 0; i < obj.length; ++i) {
                obj[i] = this.read(buff);
            }
        }
    }
}

