/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.engine;

import com.alibaba.dts.shade.org.h2.api.DatabaseEventListener;
import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.DbObject;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.value.ValueInt;
import com.alibaba.dts.shade.org.h2.value.ValueString;
import java.sql.SQLException;

public class MetaRecord
implements Comparable<MetaRecord> {
    private final int id;
    private final int objectType;
    private final String sql;

    public MetaRecord(SearchRow r) {
        this.id = r.getValue(0).getInt();
        this.objectType = r.getValue(2).getInt();
        this.sql = r.getValue(3).getString();
    }

    MetaRecord(DbObject obj) {
        this.id = obj.getId();
        this.objectType = obj.getType();
        this.sql = obj.getCreateSQL();
    }

    void setRecord(SearchRow r) {
        r.setValue(0, ValueInt.get(this.id));
        r.setValue(1, ValueInt.get(0));
        r.setValue(2, ValueInt.get(this.objectType));
        r.setValue(3, ValueString.get(this.sql));
    }

    void execute(Database db, Session systemSession, DatabaseEventListener listener) {
        try {
            Prepared command = systemSession.prepare(this.sql);
            command.setObjectId(this.id);
            command.update();
        }
        catch (DbException e) {
            e = e.addSQL(this.sql);
            SQLException s = e.getSQLException();
            db.getTrace(2).error(s, this.sql);
            if (listener != null) {
                listener.exceptionThrown(s, this.sql);
            }
            throw e;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public String getSQL() {
        return this.sql;
    }

    @Override
    public int compareTo(MetaRecord other) {
        int c2;
        int c1 = this.getCreateOrder();
        if (c1 != (c2 = other.getCreateOrder())) {
            return c1 - c2;
        }
        return this.getId() - other.getId();
    }

    private int getCreateOrder() {
        switch (this.objectType) {
            case 6: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 13: {
                return 14;
            }
        }
        throw DbException.throwInternalError("type=" + this.objectType);
    }

    public String toString() {
        return "MetaRecord [id=" + this.id + ", objectType=" + this.objectType + ", sql=" + this.sql + "]";
    }
}

