/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.spas.sdk.common.log;

import com.alibaba.dts.shade.com.taobao.middleware.logger.Level;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Logger;
import com.alibaba.dts.shade.com.taobao.middleware.logger.LoggerFactory;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogCode;

public class SpasRollingLogger {
    private static Logger logger = LoggerFactory.getLogger(SpasRollingLogger.class);

    public static void info(String s) {
        logger.info(s);
    }

    public static void info(String appName, String s) {
        logger.info(SpasRollingLogger.formatAppName(appName), s);
    }

    public static void warn(String s) {
        logger.warn(s);
    }

    public static void warn(String appName, String s) {
        logger.warn(SpasRollingLogger.formatAppName(appName), s);
    }

    public static void error(String s) {
        logger.error("", s);
    }

    public static void error(String appName, String s) {
        logger.error(SpasRollingLogger.formatAppName(appName), "", s);
    }

    public static void error(String s, Throwable throwable) {
        logger.error("", s, throwable);
    }

    public static void error(String appName, String s, Throwable throwable) {
        logger.error(SpasRollingLogger.formatAppName(appName), "", s, throwable);
    }

    public static void info(SpasLogCode code, String s) {
        logger.info(SpasRollingLogger.formatLogMessage(code, s));
    }

    public static void info(SpasLogCode code, String appName, String s) {
        logger.info(SpasRollingLogger.formatAppName(appName), SpasRollingLogger.formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String s) {
        logger.warn(SpasRollingLogger.formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String appName, String s) {
        logger.warn(SpasRollingLogger.formatAppName(appName), SpasRollingLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s) {
        logger.error("", SpasRollingLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String appName, String s) {
        logger.error(SpasRollingLogger.formatAppName(appName), "", SpasRollingLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s, Throwable throwable) {
        logger.error("", SpasRollingLogger.formatLogMessage(code, s), throwable);
    }

    public static void error(SpasLogCode code, String appName, String s, Throwable throwable) {
        logger.error(SpasRollingLogger.formatAppName(appName), "", SpasRollingLogger.formatLogMessage(code, s), throwable);
    }

    private static String formatAppName(String appName) {
        return appName == null ? "" : appName;
    }

    private static String formatLogMessage(SpasLogCode code, String s) {
        return String.format("[SPAS-%04d] %s", code.getValue(), s);
    }

    static {
        String level = System.getProperty("spas.log.level", "INFO").toUpperCase();
        logger.setLevel(Level.codeOf(level));
        String size = System.getProperty("spas.log.size", "256MB").toUpperCase();
        if (!(size.endsWith("KB") || size.endsWith("MB") || size.endsWith("GB"))) {
            size = size.endsWith("K") || size.endsWith("M") || size.endsWith("G") ? size + "B" : size + "MB";
        }
        String backupStr = System.getProperty("spas.log.backup", "20");
        int backup = Integer.valueOf(backupStr);
        logger.activateAppenderWithSizeRolling("spas", "spas_sdk_roll.log", "UTF-8", size, backup);
        logger.setAdditivity(false);
    }
}

