/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.middleware.logger.option;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Level;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Logger;
import com.alibaba.dts.shade.com.taobao.middleware.logger.option.AbstractActiveOption;
import com.alibaba.dts.shade.com.taobao.middleware.logger.option.LogbackLoggerContextUtil;
import com.alibaba.dts.shade.com.taobao.middleware.logger.support.LoggerHelper;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Iterator;

public class Logback918ActivateOption
extends AbstractActiveOption {
    private ch.qos.logback.classic.Logger logger;

    public Logback918ActivateOption(Object logger) {
        if (!(logger instanceof ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException("logger must be instanceof ch.qos.logback.classic.Logger");
        }
        this.logger = (ch.qos.logback.classic.Logger)logger;
    }

    @Override
    public void activateConsoleAppender(String target, String encoding) {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        appender.setTarget(target);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern());
        layout.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout((Layout)layout);
        appender.start();
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender((Appender)appender);
    }

    @Override
    public void activateAppender(String productName, String file, String encoding) {
        Appender appender = this.getLogbackDailyRollingFileAppender(productName, file, encoding);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    @Override
    public void activateAsyncAppender(String productName, String file, String encoding) {
        this.activateAsyncAppender(productName, file, encoding, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    @Override
    public void activateAsyncAppender(String productName, String file, String encoding, int queueSize, int discardingThreshold) {
        AsyncAppender asynAppender = new AsyncAppender();
        if (queueSize != Integer.MIN_VALUE) {
            asynAppender.setQueueSize(queueSize);
        }
        if (discardingThreshold != Integer.MIN_VALUE) {
            asynAppender.setDiscardingThreshold(discardingThreshold);
        }
        asynAppender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".AsyncAppender");
        asynAppender.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        Appender appender = this.getLogbackDailyRollingFileAppender(productName, file, encoding);
        asynAppender.addAppender(appender);
        asynAppender.start();
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender((Appender)asynAppender);
        this.setProductName(productName);
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
        this.logger.setLevel(ch.qos.logback.classic.Level.valueOf((String)level.getName()));
    }

    @Override
    public void setAdditivity(boolean additivity) {
        this.logger.setAdditive(additivity);
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size) {
        Appender appender = this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    protected Appender getLogbackDailyRollingFileAppender(String productName, String file, String encoding) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        TimeBasedRollingPolicy rolling = new TimeBasedRollingPolicy();
        rolling.setParent((FileAppender)appender);
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%d{yyyy-MM-dd}");
        rolling.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        rolling.start();
        appender.setRollingPolicy((RollingPolicy)rolling);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout((Layout)layout);
        appender.start();
        return appender;
    }

    protected Appender getLogbackDailyAndSizeRollingFileAppender(String productName, String file, String encoding, String size) {
        return this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size, "yyyy-MM-dd", -1);
    }

    @Override
    public void activateAppender(Logger logger) {
        if (!(logger.getDelegate() instanceof ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException("logger must be ch.qos.logback.classic.Logger, but it's " + logger.getDelegate().getClass());
        }
        this.logger.detachAndStopAllAppenders();
        Iterator iter = ((ch.qos.logback.classic.Logger)logger.getDelegate()).iteratorForAppenders();
        while (iter.hasNext()) {
            Appender appender = (Appender)iter.next();
            this.logger.addAppender(appender);
        }
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size, String datePattern) {
        Appender appender = this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size, datePattern, -1);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    protected Appender getLogbackDailyAndSizeRollingFileAppender(String productName, String file, String encoding, String size, String datePattern, int maxBackupIndex) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        TimeBasedRollingPolicy rolling = new TimeBasedRollingPolicy();
        rolling.setParent((FileAppender)appender);
        if (maxBackupIndex >= 0) {
            rolling.setMaxHistory(maxBackupIndex);
        }
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%d{" + datePattern + "}.%i");
        rolling.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        SizeAndTimeBasedFNATP fnatp = new SizeAndTimeBasedFNATP();
        this.setMaxFileSize(fnatp, size);
        fnatp.setTimeBasedRollingPolicy(rolling);
        rolling.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)fnatp);
        rolling.start();
        appender.setRollingPolicy((RollingPolicy)rolling);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout((Layout)layout);
        appender.start();
        return appender;
    }

    @Override
    public void activateAppenderWithTimeAndSizeRolling(String productName, String file, String encoding, String size, String datePattern, int maxBackupIndex) {
        Appender appender = this.getLogbackDailyAndSizeRollingFileAppender(productName, file, encoding, size, datePattern, maxBackupIndex);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    @Override
    public void activateAppenderWithSizeRolling(String productName, String file, String encoding, String size, int maxBackupIndex) {
        Appender appender = this.getSizeRollingAppender(productName, file, encoding, size, maxBackupIndex);
        this.logger.detachAndStopAllAppenders();
        this.logger.addAppender(appender);
        this.setProductName(productName);
    }

    protected Appender getSizeRollingAppender(String productName, String file, String encoding, String size, int maxBackupIndex) {
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        appender.setName(productName + "." + file.replace(File.separatorChar, '.') + ".Appender");
        appender.setAppend(true);
        appender.setFile(LoggerHelper.getLogFile(productName, file));
        SizeBasedTriggeringPolicy triggerPolicy = new SizeBasedTriggeringPolicy();
        this.setMaxFileSize(triggerPolicy, size);
        triggerPolicy.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        triggerPolicy.start();
        FixedWindowRollingPolicy rolling = new FixedWindowRollingPolicy();
        rolling.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        rolling.setParent((FileAppender)appender);
        rolling.setFileNamePattern(LoggerHelper.getLogFile(productName, file) + ".%i");
        rolling.setParent((FileAppender)appender);
        if (maxBackupIndex >= 0) {
            rolling.setMaxIndex(maxBackupIndex);
        }
        rolling.start();
        appender.setRollingPolicy((RollingPolicy)rolling);
        appender.setTriggeringPolicy((TriggeringPolicy)triggerPolicy);
        PatternLayout layout = new PatternLayout();
        layout.setPattern(LoggerHelper.getPattern(productName));
        layout.setContext((Context)LogbackLoggerContextUtil.getLoggerContext());
        layout.start();
        appender.setLayout((Layout)layout);
        appender.start();
        return appender;
    }

    protected void setMaxFileSize(Object policy, String size) {
        try {
            try {
                Method setMaxFileSizeMethod = policy.getClass().getDeclaredMethod("setMaxFileSize", String.class);
                setMaxFileSizeMethod.invoke(policy, size);
            }
            catch (NoSuchMethodException e) {
                Method setMaxFileSizeMethod = policy.getClass().getDeclaredMethod("setMaxFileSize", FileSize.class);
                setMaxFileSizeMethod.invoke(policy, FileSize.valueOf((String)size));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to setMaxFileSize", t);
        }
    }
}

