/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.BaseLoggerBuilder;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeLogDaemon;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeRollingFileAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatLogController;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatLogger;
import com.alibaba.dts.shade.com.taobao.eagleeye.SyncAppender;
import java.util.concurrent.TimeUnit;

public final class StatLoggerBuilder
extends BaseLoggerBuilder<StatLoggerBuilder> {
    private int intervalSeconds = 60;
    private int maxEntryCount = 20000;
    private char keyDelimiter = (char)44;
    private char valueDelimiter = (char)44;
    private EagleEyeAppender appender = null;

    StatLoggerBuilder(String loggerName) {
        super(loggerName);
    }

    public StatLoggerBuilder intervalSeconds(int intervalSeconds) {
        StatLoggerBuilder.validateInterval(intervalSeconds);
        this.intervalSeconds = intervalSeconds;
        return this;
    }

    public StatLoggerBuilder maxEntryCount(int maxEntryCount) {
        if (maxEntryCount < 1) {
            throw new IllegalArgumentException("\u6700\u5927\u7edf\u8ba1\u9879\u7684\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e 1: " + maxEntryCount);
        }
        this.maxEntryCount = maxEntryCount;
        return this;
    }

    public StatLoggerBuilder keyDelimiter(char keyDelimiter) {
        this.keyDelimiter = keyDelimiter;
        return this;
    }

    public StatLoggerBuilder valueDelimiter(char valueDelimiter) {
        this.valueDelimiter = valueDelimiter;
        return this;
    }

    StatLoggerBuilder appender(EagleEyeAppender appender) {
        this.appender = appender;
        return this;
    }

    StatLogger create() {
        long intervalMillis = TimeUnit.SECONDS.toMillis(this.intervalSeconds);
        String filePath = this.filePath == null ? EagleEye.EAGLEEYE_LOG_DIR + "stat-" + this.loggerName + ".log" : (this.filePath.endsWith("/") || this.filePath.endsWith("\\") ? this.filePath + "stat-" + this.loggerName + ".log" : this.filePath);
        EagleEyeAppender appender = this.appender;
        if (appender == null) {
            EagleEyeRollingFileAppender rfappender = new EagleEyeRollingFileAppender(filePath, this.maxFileSize);
            rfappender.setMaxBackupIndex(this.maxBackupIndex);
            appender = new SyncAppender(rfappender);
        }
        EagleEyeLogDaemon.watch(appender);
        return new StatLogger(this.loggerName, appender, intervalMillis, this.maxEntryCount, this.entryDelimiter, this.keyDelimiter, this.valueDelimiter);
    }

    public StatLogger buildSingleton() {
        return StatLogController.createLoggerIfNotExists(this);
    }

    static void validateInterval(long intervalSeconds) throws IllegalArgumentException {
        if (intervalSeconds < 1L) {
            throw new IllegalArgumentException("\u7edf\u8ba1\u95f4\u9694\u4e0d\u80fd\u5c0f\u4e8e 1: " + intervalSeconds);
        }
        if (intervalSeconds < 60L) {
            if (60L % intervalSeconds != 0L) {
                throw new IllegalArgumentException("\u4e00\u5206\u949f\u4ee5\u5185\u7684\u7edf\u8ba1\u95f4\u9694\u9700\u8981\u88ab 60 \u6574\u9664: " + intervalSeconds);
            }
        } else if (intervalSeconds <= 300L) {
            if (intervalSeconds % 60L != 0L) {
                throw new IllegalArgumentException("\u8d85\u8fc7\u4e00\u5206\u949f\u7684\u7edf\u8ba1\u95f4\u9694\u9700\u8981\u80fd\u6574\u9664 60: " + intervalSeconds);
            }
            if (60L % intervalSeconds != 0L) {
                throw new IllegalArgumentException("\u4e00\u5c0f\u65f6\u4ee5\u5185\u7684\u7edf\u8ba1\u95f4\u9694\u9700\u8981\u88ab 60 \u6574\u9664: " + intervalSeconds);
            }
        } else if (intervalSeconds > 300L) {
            throw new IllegalArgumentException("\u7edf\u8ba1\u95f4\u9694\u4e0d\u80fd\u8d85\u8fc7\u4e94\u5206\u949f: " + intervalSeconds);
        }
    }
}

