/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContextEncoder;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import com.alibaba.dts.shade.com.taobao.eagleeye.NoOpAppender;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

class AsyncAppender
extends EagleEyeAppender {
    private static final int DEFAULT_NOTIFY_THRESHOLD = 512;
    static final int LOG_TYPE_EVENT_FLUSH = -1;
    static final BaseContext EVENT_LOG_FLUSH = new BaseContext(-1);
    static final int LOG_TYPE_EVENT_ROLLOVER = -2;
    static final BaseContext EVENT_LOG_ROLLOVER = new BaseContext(-2);
    static final int LOG_TYPE_EVENT_RELOAD = -3;
    static final BaseContext EVENT_LOG_RELOAD = new BaseContext(-3);
    private final BaseContext[] entries;
    private final int queueSize;
    private final int indexMask;
    private final int notifyThreshold;
    private final int maxWaitMillis;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private AtomicLong putIndex;
    private AtomicLong discardCount;
    private AtomicLong takeIndex;
    private EagleEyeAppender appender;
    private BaseContextEncoder encoder;
    private String workerName;
    private Thread worker;
    private AtomicBoolean running;

    public AsyncAppender(int queueSize, int maxWaitMillis) {
        this.queueSize = queueSize = 1 << 32 - Integer.numberOfLeadingZeros(queueSize - 1);
        this.maxWaitMillis = maxWaitMillis;
        this.entries = new BaseContext[queueSize];
        this.indexMask = queueSize - 1;
        this.notifyThreshold = queueSize >= 512 ? 512 : queueSize;
        this.putIndex = new AtomicLong(0L);
        this.discardCount = new AtomicLong(0L);
        this.takeIndex = new AtomicLong(0L);
        this.running = new AtomicBoolean(false);
        this.lock = new ReentrantLock(false);
        this.notEmpty = this.lock.newCondition();
    }

    void start(EagleEyeAppender appender, BaseContextEncoder encoder, String workerName) {
        if (appender instanceof AsyncAppender) {
            throw new IllegalArgumentException("nested AsyncAppender is not allow: " + workerName);
        }
        this.appender = EagleEyeCoreUtils.checkNotNull(appender, "appender");
        this.encoder = encoder;
        this.workerName = workerName;
        this.worker = new Thread((Runnable)new AsyncRunnable(), "EagleEye-AsyncAppender-Thread-" + workerName);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    int size() {
        return (int)(this.putIndex.get() - this.takeIndex.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean append(BaseContext ctx) {
        long size;
        long qsize = this.queueSize;
        long startTime = 0L;
        while (true) {
            long put;
            if ((size = (put = this.putIndex.get()) - this.takeIndex.get()) >= qsize) {
                if (this.maxWaitMillis <= 0) {
                    this.discardCount.incrementAndGet();
                    return false;
                }
                long now = System.currentTimeMillis();
                if (startTime == 0L) {
                    startTime = now;
                } else if (now - startTime >= (long)this.maxWaitMillis) {
                    this.discardCount.incrementAndGet();
                    return false;
                }
                LockSupport.parkNanos(1000L);
                continue;
            }
            if (this.putIndex.compareAndSet(put, put + 1L)) break;
        }
        this.entries[(int)put & this.indexMask] = ctx;
        if (size >= (long)this.notifyThreshold && !this.running.get() && this.lock.tryLock()) {
            try {
                this.notEmpty.signal();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to signal notEmpty: " + this.workerName, e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    @Override
    public void append(String log) {
        throw new UnsupportedOperationException("use append(BaseContext ctx) instead in AsyncAppender");
    }

    @Override
    public void rollOver() {
        this.append(EVENT_LOG_ROLLOVER);
    }

    @Override
    public void reload() {
        this.append(EVENT_LOG_RELOAD);
    }

    @Override
    public void flush() {
        this.append(EVENT_LOG_FLUSH);
    }

    @Override
    public void close() {
        EagleEyeAppender appender0 = this.appender;
        this.appender = new NoOpAppender();
        appender0.close();
    }

    @Override
    public void cleanup() {
        this.appender.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAndWait() {
        this.append(EVENT_LOG_FLUSH);
        long end = System.currentTimeMillis() + 500L;
        while (this.size() > 0 && System.currentTimeMillis() <= end) {
            if (this.running.get()) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (!this.lock.tryLock()) continue;
            try {
                this.notEmpty.signal();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to signal notEmpty: " + this.workerName, e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    EagleEyeAppender getEagleEyeAppender() {
        return this.appender;
    }

    void setEagleEyeAppender(EagleEyeAppender appender) {
        this.appender = EagleEyeCoreUtils.checkNotNull(appender, "appender");
    }

    public String toString() {
        return "AsyncAppender [appender=" + this.appender + "]";
    }

    class AsyncRunnable
    implements Runnable {
        AsyncRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            AsyncAppender parent = AsyncAppender.this;
            int indexMask = parent.indexMask;
            int queueSize = parent.queueSize;
            BaseContextEncoder encoder = parent.encoder;
            String workerName = parent.workerName;
            BaseContext[] entries = parent.entries;
            AtomicLong putIndex = parent.putIndex;
            AtomicLong takeIndex = parent.takeIndex;
            AtomicLong discardCount = parent.discardCount;
            AtomicBoolean running = parent.running;
            ReentrantLock lock = parent.lock;
            Condition notEmpty = parent.notEmpty;
            long outputSpan = TimeUnit.MINUTES.toMillis(1L);
            long lastOutputTime = System.currentTimeMillis();
            while (true) {
                try {
                    while (true) {
                        long now;
                        running.set(true);
                        long take = takeIndex.get();
                        long size = putIndex.get() - take;
                        if (size <= 0L) {
                            if (!lock.tryLock()) continue;
                            try {
                                running.set(false);
                                notEmpty.await(1L, TimeUnit.SECONDS);
                            }
                            finally {
                                lock.unlock();
                            }
                            continue;
                        }
                        do {
                            int idx = (int)take & indexMask;
                            BaseContext ctx = entries[idx];
                            while (ctx == null) {
                                Thread.yield();
                                ctx = entries[idx];
                            }
                            entries[idx] = null;
                            takeIndex.set(++take);
                            this.processContext(ctx, parent.appender, encoder);
                        } while (--size > 0L);
                        long discardNum = discardCount.get();
                        if (discardNum > 0L && (now = System.currentTimeMillis()) - lastOutputTime > outputSpan) {
                            discardNum = discardCount.get();
                            discardCount.lazySet(0L);
                            EagleEye.selfLog("[WARN] " + workerName + " discarded " + discardNum + " logs, queueSize=" + queueSize);
                            lastOutputTime = now;
                        }
                        parent.appender.flush();
                    }
                }
                catch (InterruptedException e) {
                    EagleEye.selfLog("[WARN] " + workerName + " async thread is iterrupted");
                }
                catch (Exception e) {
                    EagleEye.selfLog("[ERROR] Fail to async write log " + workerName, e);
                    continue;
                }
                break;
            }
            running.set(false);
        }

        private final void processContext(BaseContext ctx, EagleEyeAppender appender, BaseContextEncoder encoder) throws IOException {
            int logType = ctx.logType;
            if (logType < 0) {
                if (logType == -1) {
                    appender.flush();
                } else if (logType == -2) {
                    appender.rollOver();
                } else if (logType == -3) {
                    appender.reload();
                }
            } else {
                encoder.encode(ctx, appender);
            }
        }
    }
}

