/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceGroup;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AbstractContext
extends BaseContext {
    public static final String EAGLEEYE_TRACE_GROUP_KEY = "g";
    protected static final String EMPTY_LOCALID = "";
    String remoteIp = "";
    int span0 = 0;
    int span1 = 0;
    boolean isTopRpc = false;
    long startTime = 0L;
    long requestSize = 0L;
    long responseSize = 0L;
    TraceGroup traceGroup = null;
    Map<String, String> attributes = null;
    Map<String, String> localAttributes = null;
    String localId = "";
    final AtomicInteger localIdx;

    AbstractContext(String _traceId, String _rpcId) {
        this(_traceId, _rpcId, new AtomicInteger(0));
    }

    AbstractContext(String _traceId, String _rpcId, AtomicInteger _localIdx) {
        super(_traceId, _rpcId);
        this.localIdx = _localIdx;
    }

    public String getLocalId() {
        return this.localId;
    }

    public long getRequestSize() {
        return this.requestSize;
    }

    public void setRequestSize(long requestSize) {
        this.requestSize = requestSize;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public void setResponseSize(long responseSize) {
        this.responseSize = responseSize;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setTimeSpan0(int span0) {
        this.span0 = span0;
    }

    public int getTimeSpan0() {
        return this.span0;
    }

    public void setTimeSpan1(int span1) {
        this.span1 = span1;
    }

    public int getTimeSpan1() {
        return this.span1;
    }

    public void startRpc(String serviceName, String methodName) {
        this.logType = 2;
        this.startTime = System.currentTimeMillis();
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.span0 = 0;
    }

    public void endRpc(String result, int type, String appendMsg) {
        if (this.logType != 2) {
            EagleEye.selfLog("[WARN] context mismatch at endRpc(), logType=" + this.logType);
            this.logType = -255;
            return;
        }
        this.logTime = System.currentTimeMillis();
        this.rpcType = type;
        this.traceName = result;
        if (appendMsg != null) {
            this.callBackMsg = appendMsg;
        }
        this.span1 = (int)(this.logTime - this.startTime);
    }

    public boolean isTraceSampled() {
        if (this.traceId == null) {
            return false;
        }
        int si = EagleEye.getSamplingInterval();
        if (si <= 1 || si >= 10000) {
            return true;
        }
        if (this.traceId.length() < 25) {
            return this.traceId.hashCode() % si == 0;
        }
        int count = this.traceId.charAt(21) - 48;
        count = count * 10 + this.traceId.charAt(22) - 48;
        count = count * 10 + this.traceId.charAt(23) - 48;
        return (count = count * 10 + this.traceId.charAt(24) - 48) % si == 0;
    }

    boolean isAppendExtendMsg() {
        boolean appendTraceGroup;
        boolean bl = appendTraceGroup = this.traceGroup != null;
        if (!appendTraceGroup) {
            return false;
        }
        return !appendTraceGroup;
    }

    protected void doAppendTraceGroup(StringBuilder appender, boolean escapeChars) {
        TraceGroup traceGroup = this.traceGroup;
        if (traceGroup != null) {
            appender.append('@').append(EAGLEEYE_TRACE_GROUP_KEY).append('\u0014');
            if (escapeChars) {
                EagleEyeCoreUtils.appendLog(traceGroup.getAppName(), appender, '|').append('$');
                EagleEyeCoreUtils.appendLog(traceGroup.getKey1(), appender, '|').append('$');
                EagleEyeCoreUtils.appendLog(traceGroup.getKey2(), appender, '|').append('$');
                EagleEyeCoreUtils.appendLog(traceGroup.getKey3(), appender, '|');
            } else {
                appender.append(traceGroup.getAppName()).append('$').append(traceGroup.getKey1()).append('$').append(traceGroup.getKey2()).append('$').append(traceGroup.getKey3());
            }
            appender.append('\u0012');
        }
    }

    void logContextData(StringBuilder appender) {
        boolean appendTraceGroup;
        boolean appendAttributes = this.attributes != null && !this.attributes.isEmpty();
        boolean appendLocalAttributes = this.localAttributes != null && !this.localAttributes.isEmpty();
        boolean bl = appendTraceGroup = this.traceGroup != null;
        if (!(appendAttributes || appendLocalAttributes || appendTraceGroup)) {
            return;
        }
        appender.append("|@");
        int startLen = appender.length();
        if (appendAttributes) {
            this.doAppendUserData(appender, true, startLen);
        }
        if (appendLocalAttributes) {
            this.doAppendLocalAttributes(appender, true, startLen);
        }
        if (appendTraceGroup) {
            this.doAppendTraceGroup(appender, true);
        }
    }

    protected void doAppendUserData(StringBuilder appender, boolean escapeChars, int startLen) {
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (EagleEyeCoreUtils.isNotBlank(key) && value != null) {
                appender.append(key).append('\u0014');
                if (escapeChars) {
                    EagleEyeCoreUtils.appendLog(value, appender, '|').append('\u0012');
                } else {
                    appender.append(value).append('\u0012');
                }
            }
            if (appender.length() - startLen < 1024) continue;
            EagleEye.selfLog("[WARN] UserData is too long, size=" + appender.length());
            break;
        }
    }

    protected void doAppendLocalAttributes(StringBuilder appender, boolean escapeChars, int startLen) {
        for (Map.Entry<String, String> entry : this.localAttributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (EagleEyeCoreUtils.isNotBlank(key) && value != null) {
                appender.append('@').append(key).append('\u0014');
                if (escapeChars) {
                    EagleEyeCoreUtils.appendLog(value, appender, '|').append('\u0012');
                } else {
                    appender.append(value).append('\u0012');
                }
            }
            if (appender.length() - startLen < 1024) continue;
            EagleEye.selfLog("[WARN] UserData is too long, size=" + appender.length());
            break;
        }
    }

    public String putUserData(String key, String value) {
        if (EagleEyeCoreUtils.isBlank(key) || key.length() > 512) {
            EagleEye.selfLog("[WARN] userData is not accepted since key is blank or too long: " + key);
            return null;
        }
        if (value != null && value.length() > 512) {
            EagleEye.selfLog("[WARN] userData is not accepted since value is too long: " + value);
            return null;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        return this.attributes.put(key, value);
    }

    public String removeUserData(String key) {
        if (this.attributes != null) {
            return this.attributes.remove(key);
        }
        return null;
    }

    public String getUserData(String key) {
        return this.attributes != null ? this.attributes.get(key) : null;
    }

    public Map<String, String> getUserDataMap() {
        return this.attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.attributes);
    }

    public String putLocalAttribute(String key, String value) {
        if (this.localAttributes == null) {
            this.localAttributes = new LinkedHashMap<String, String>();
        }
        return this.localAttributes.put(key, value);
    }

    public String removeLocalAttribute(String key) {
        if (this.localAttributes != null) {
            return this.localAttributes.remove(key);
        }
        return null;
    }

    public String getLocalAttribute(String key) {
        return this.localAttributes != null ? this.localAttributes.get(key) : null;
    }

    public Map<String, String> getLocalAttributeMap() {
        if (this.localAttributes == null) {
            this.localAttributes = new LinkedHashMap<String, String>();
        }
        return this.localAttributes;
    }

    public TraceGroup traceGroup(String appName) {
        if (this.traceGroup == null) {
            this.traceGroup = new TraceGroup(appName);
        }
        return this.traceGroup;
    }

    public String exportUserData() {
        Map<String, String> userData = this.attributes;
        if (userData == null || userData.isEmpty()) {
            return null;
        }
        StringBuilder appender = new StringBuilder(256);
        this.doAppendUserData(appender, false, 0);
        if (appender.length() == 0) {
            return null;
        }
        return appender.toString();
    }

    public void importUserData(String userData) {
        if (EagleEyeCoreUtils.isNotBlank(userData) && EagleEye.isUserDataEnabled()) {
            String[] entries = EagleEyeCoreUtils.split(userData, '\u0012');
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(entries.length);
            for (String entry : entries) {
                int p = entry.indexOf(20);
                if (p <= 0 || p >= entry.length() || p == 1 && entry.charAt(0) == 't' && !EagleEye.isClusterTestEnabled()) continue;
                map.put(entry.substring(0, p), entry.substring(p + 1));
            }
            if (!map.isEmpty()) {
                this.attributes = map;
            }
        }
    }
}

