/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.diamond.client.impl;

import com.alibaba.dts.shade.com.taobao.diamond.client.BatchHttpResult;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.CacheData;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.ClientWorker;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.HttpSimpleClient;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.LogUtils;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.ServerHttpAgent;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.ServerListManager;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.SpasAdapter;
import com.alibaba.dts.shade.com.taobao.diamond.common.Constants;
import com.alibaba.dts.shade.com.taobao.diamond.common.GroupKey;
import com.alibaba.dts.shade.com.taobao.diamond.domain.ConfigInfoEx;
import com.alibaba.dts.shade.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.dts.shade.com.taobao.diamond.mockserver.MockServer;
import com.alibaba.dts.shade.com.taobao.diamond.utils.ContentUtils;
import com.alibaba.dts.shade.com.taobao.diamond.utils.JSONUtils;
import com.alibaba.dts.shade.com.taobao.diamond.utils.StringUtils;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Logger;
import com.alibaba.dts.shade.com.taobao.middleware.logger.support.LoggerHelper;
import com.alibaba.dts.shade.org.codehaus.jackson.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class DiamondEnv {
    public static final Logger log = LogUtils.logger(DiamondEnv.class);
    public static final long POST_TIMEOUT = 3000L;
    protected ServerListManager serverMgr;
    protected ServerHttpAgent agent;
    protected ClientWorker worker;
    private final AtomicReference<Map<String, CacheData>> cacheMap;

    public void addListeners(String dataId, String group, List<? extends ManagerListener> listeners) {
        group = this.null2defaultGroup(group);
        CacheData cache = this.addCacheDataIfAbsent(dataId, group);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    public void removeListener(String dataId, String group, ManagerListener listener) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group);
            }
        }
    }

    public List<ManagerListener> getListeners(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (null == cache) {
            return Collections.emptyList();
        }
        return cache.getListeners();
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws IOException {
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group);
        if (content != null) {
            log.warn(this.getName(), "[get-config] get failover ok, dataId={}, group={}, config={}", dataId, group, ContentUtils.truncateContent(content));
            return content;
        }
        try {
            return ClientWorker.getServerConfig(this, dataId, group, timeoutMs);
        }
        catch (IOException ioe) {
            if ("No right".equals(ioe.getMessage())) {
                throw ioe;
            }
            log.warn("Diamond-0003", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0003", "\u73af\u5883\u95ee\u9898", "get from server error"));
            log.warn(this.getName(), "[get-config] get from server error, dataId={}, group={}, msg={}", dataId, group, ioe.toString());
            log.warn(this.getName(), "[get-config] get snapshot ok, dataId={}, group={}, config={}", dataId, group, ContentUtils.truncateContent(content));
            return LocalConfigInfoProcessor.getSnapshot(this, dataId, group);
        }
    }

    public String getConfig(String dataId, String group, int feature, long timeoutMs) throws IOException {
        if (feature == 1) {
            return this.getConfig(dataId, group, timeoutMs);
        }
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group);
        if (content != null) {
            log.warn(this.getName(), "[get-config] get failover ok, dataId={}, group={}, config={}", dataId, group, ContentUtils.truncateContent(content));
            return content;
        }
        content = LocalConfigInfoProcessor.getSnapshot(this, dataId, group);
        if (StringUtils.isNotEmpty(content)) {
            log.warn(this.getName(), "[get-config] get snapshot ok, dataId={}, group={}, config={}", dataId, group, ContentUtils.truncateContent(content));
            return content;
        }
        return ClientWorker.getServerConfig(this, dataId, group, timeoutMs);
    }

    public String getConfigFromSnapshot(String dataId, String group) {
        return LocalConfigInfoProcessor.getSnapshot(this, dataId, group);
    }

    public boolean publishSingle(String dataId, String group, String content) {
        return this.publishSingle(dataId, group, null, content);
    }

    public boolean publishSingle(String dataId, String group, String appName, String content) {
        DiamondEnv.checkNotNull(dataId, content);
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            MockServer.setConfigInfo(dataId, group, content, this);
            return true;
        }
        String url = "/basestone.do?method=syncUpdateAll";
        List<String> params = null;
        params = appName == null ? Arrays.asList("dataId", dataId, "group", group, "content", content) : Arrays.asList("dataId", dataId, "group", group, "appName", appName, "content", content);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn("Diamond-0006", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0006", "\u73af\u5883\u95ee\u9898", "[publish-single] exception"));
            log.warn(this.getName(), "[publish-single] exception, dataId={}, group={}, msg={}", dataId, group, ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[publish-single] ok, dataId={}, group={}, config={}", dataId, group, ContentUtils.truncateContent(content));
            return true;
        }
        log.warn(this.getName(), "[publish-single] error, dataId={}, group={}, code={}, msg={}", dataId, group, result.code, result.content);
        return false;
    }

    public boolean publishAggr(String dataId, String group, String datumId, String content) {
        return this.publishAggr(dataId, group, datumId, null, content);
    }

    public boolean publishAggr(String dataId, String group, String datumId, String appName, String content) {
        DiamondEnv.checkNotNull(dataId, datumId, content);
        group = this.null2defaultGroup(group);
        String url = "/datum.do?method=addDatum";
        List<String> params = null;
        params = appName == null ? Arrays.asList("dataId", dataId, "group", group, "datumId", datumId, "content", content) : Arrays.asList("dataId", dataId, "group", group, "datumId", datumId, "appName", appName, "content", content);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[publish-aggr] exception, dataId={}, group={}, datumId={}, msg={}", dataId, group, datumId, ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[publish-aggr] ok, dataId={}, group={}, datumId={}, config={}", dataId, group, datumId, ContentUtils.truncateContent(content));
            return true;
        }
        if (result.code == 403) {
            log.error("Diamond-0004", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0004", "\u4e1a\u52a1\u95ee\u9898", "[publish-aggr] error"));
        }
        log.error(this.getName(), "[publish-aggr] error, dataId={}, group={}, code={}, msg={}", dataId, group, result.code, result.content);
        return false;
    }

    public boolean removeAggr(String dataId, String group, String datumId) {
        DiamondEnv.checkNotNull(dataId, datumId);
        group = this.null2defaultGroup(group);
        String url = "/datum.do?method=deleteDatum";
        List<String> params = Arrays.asList("dataId", dataId, "group", group, "datumId", datumId);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[remove-aggr] exception, dataId={}, group={}, datumId={}, msg={}", dataId, group, datumId, ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[remove-aggr] ok, dataId={}, group={}, datumId={}", dataId, group, datumId);
            return true;
        }
        log.error(this.getName(), "[remove-aggr] error, dataId={}, group={}, datumId={}, code={}, msg={}", dataId, group, datumId, result.code, result.content);
        return false;
    }

    public boolean remove(String dataId, String group) {
        DiamondEnv.checkNotNull(dataId);
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            MockServer.removeConfigInfo(dataId, group, this);
            return true;
        }
        String url = "/datum.do?method=deleteAllDatums";
        List<String> params = Arrays.asList("dataId", dataId, "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn("[remove] error, " + dataId + ", " + group + ", msg: " + ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[remove] ok, dataId={}, group={}", dataId, group);
            return true;
        }
        log.warn(this.getName(), "[remove] error, dataId={}, group={}, code={}, msg={}", dataId, group, result.code, result.content);
        return false;
    }

    public List<String> getServerUrls() {
        return new ArrayList<String>(this.serverMgr.serverUrls);
    }

    private static void checkNotNull(String ... params) {
        for (String param : params) {
            if (!StringUtils.isBlank(param)) continue;
            throw new IllegalArgumentException("param cannot be blank");
        }
    }

    private String null2defaultGroup(String group) {
        return null == group ? "DEFAULT_GROUP" : group.trim();
    }

    public BatchHttpResult<ConfigInfoEx> batchGetConfig(List<String> dataIds, String group, long timeoutMs) {
        if (dataIds == null) {
            throw new IllegalArgumentException("dataId list is null when batch get config");
        }
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            List<ConfigInfoEx> result = MockServer.batchQuery(dataIds, group, this);
            BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>(true, 200, "", "mock server");
            response.getResult().addAll(result);
            return response;
        }
        StringBuilder dataIdstr = new StringBuilder();
        String split = "";
        for (String dataId : dataIds) {
            dataIdstr.append(split);
            dataIdstr.append(dataId);
            split = Constants.WORD_SEPARATOR;
        }
        String url = "/config.co?method=batchGetConfig";
        List<String> params = Arrays.asList("dataIds", dataIdstr.toString(), "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", timeoutMs);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batch-get] exception, dataIds={}, group={}, msg={}", dataIds, group, ioe);
            return new BatchHttpResult<ConfigInfoEx>(false, -1, "batch get config io exception:" + ioe.getMessage(), "");
        }
        BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>(true, result.code, "", result.content);
        if (result.code == 200) {
            response.setSuccess(true);
            response.setStatusMsg("batch get config success");
            log.info(this.getName(), "[batch-get] ok, dataIds={}, group={}", dataIds, group);
        } else {
            response.setSuccess(false);
            response.setStatusMsg("batch get config fail, status:" + result.code);
            log.warn(this.getName(), "[batch-get] error, dataIds={}, group={}, code={}, msg={}", dataIds, group, result.code, result.content);
        }
        if (200 == result.code || 412 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject(json, new TypeReference<List<ConfigInfoEx>>(){});
                response.getResult().addAll((List)resultObj);
                LocalConfigInfoProcessor.batchSaveSnapshot(this, (List)resultObj);
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setStatusMsg("batch get config deserialize error");
                log.warn(this.getName(), "[batch-get] deserialize error, dataIds={}, group={}, msg={}", dataIds, group, e.toString());
            }
        }
        return response;
    }

    public BatchHttpResult<ConfigInfoEx> batchQuery(List<String> dataIds, String group, long timeoutMs) {
        BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>();
        if (dataIds == null) {
            throw new IllegalArgumentException("dataId list is null when batch query");
        }
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            List<ConfigInfoEx> result = MockServer.batchQuery(dataIds, group, this);
            response.setStatusCode(200);
            response.setResponseMsg("mock server");
            response.setSuccess(true);
            response.getResult().addAll(result);
            return response;
        }
        StringBuilder dataIdstr = new StringBuilder();
        String split = "";
        for (String dataId : dataIds) {
            dataIdstr.append(split);
            dataIdstr.append(dataId);
            split = Constants.WORD_SEPARATOR;
        }
        String url = "/admin.do?method=batchQuery";
        List<String> params = Arrays.asList("dataIds", dataIdstr.toString(), "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", timeoutMs);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batch-query] exception, dataIds={}, group={}, msg={}", dataIds, group, ioe);
            response.setSuccess(false);
            response.setStatusMsg("batch query io exception\uff1a" + ioe.getMessage());
            return response;
        }
        response.setStatusCode(result.code);
        response.setResponseMsg(result.content);
        if (200 == result.code || 412 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject(json, new TypeReference<List<ConfigInfoEx>>(){});
                response.setSuccess(true);
                response.getResult().addAll((List)resultObj);
                log.info(this.getName(), "[batch-query] ok, dataIds={}, group={}", dataIds, group);
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setStatusMsg("batch query deserialize error");
                log.warn(this.getName(), "[batch-query] deserialize error, dataIds={}, group={}, msg={}", dataIds, group, e.toString());
            }
        } else {
            response.setSuccess(false);
            response.setStatusMsg("batch query fail, status:" + result.code);
            log.warn(this.getName(), "[batch-query] error, dataIds={}, group={}, code={}, msg={}", dataIds, group, result.code, result.content);
            return response;
        }
        return response;
    }

    public boolean batchRemoveAggr(String dataId, String group, List<String> datumIdList, long timeoutMs) {
        DiamondEnv.checkNotNull(dataId, group);
        if (datumIdList == null || datumIdList.isEmpty()) {
            throw new IllegalArgumentException("datumIdList cannot be blank");
        }
        StringBuilder datumStr = new StringBuilder();
        for (String datum : datumIdList) {
            datumStr.append(datum).append(Constants.WORD_SEPARATOR);
        }
        String url = "/datum.do?method=batchDeleteAggrs";
        List<String> params = Arrays.asList("dataId", dataId, "group", group, "datumList", datumStr.toString());
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", timeoutMs);
            if (result.code == 200) {
                return true;
            }
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batchRemoveAggr] exception, dataId{}, group={}, msg={}", dataId, group, ioe);
        }
        return false;
    }

    public boolean batchPublishAggr(String dataId, String group, Map<String, String> datumMap, long timeoutMs) {
        return this.batchPublishAggr(dataId, group, datumMap, null, timeoutMs);
    }

    public boolean batchPublishAggr(String dataId, String group, Map<String, String> datumMap, String appName, long timeoutMs) {
        DiamondEnv.checkNotNull(dataId, group);
        if (datumMap == null || datumMap.isEmpty()) {
            throw new IllegalArgumentException("datumMap cannot be blank");
        }
        StringBuilder datumStr = new StringBuilder();
        for (Map.Entry<String, String> datumEntry : datumMap.entrySet()) {
            datumStr.append(datumEntry.getKey()).append(Constants.WORD_SEPARATOR).append(datumEntry.getValue()).append(Constants.LINE_SEPARATOR);
        }
        String url = "/datum.do?method=batchAddAggrs";
        List<String> params = null;
        params = appName == null ? Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString()) : Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString(), "appName", appName);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", timeoutMs);
            if (result.code == 200) {
                log.info(this.getName(), "[batchPublishAggr] ok, dataId={}, group={}", dataId, group);
                return true;
            }
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batchPublishAggr] exception, dataId{}, group={}, msg={}", dataId, group, ioe);
        }
        return false;
    }

    public boolean replaceAggr(String dataId, String group, Map<String, String> datumMap, long timeoutMs) {
        return this.replaceAggr(dataId, group, datumMap, null, timeoutMs);
    }

    public boolean replaceAggr(String dataId, String group, Map<String, String> datumMap, String appName, long timeoutMs) {
        DiamondEnv.checkNotNull(dataId, group);
        if (datumMap == null || datumMap.isEmpty()) {
            throw new IllegalArgumentException("datumMap cannot be blank");
        }
        StringBuilder datumStr = new StringBuilder();
        for (Map.Entry<String, String> datumEntry : datumMap.entrySet()) {
            datumStr.append(datumEntry.getKey()).append(Constants.WORD_SEPARATOR).append(datumEntry.getValue()).append(Constants.LINE_SEPARATOR);
        }
        String url = "/datum.do?method=replaceAggr";
        List<String> params = null;
        params = appName == null ? Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString()) : Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString(), "appName", appName);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, SpasAdapter.getSignHeaders(group), params, "GBK", timeoutMs);
            if (result.code == 200) {
                return true;
            }
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[replaceAggr] exception, dataId{}, group={}, msg={}", dataId, group, ioe);
        }
        return false;
    }

    CacheData getCache(String dataId, String group) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException();
        }
        return this.cacheMap.get().get(GroupKey.getKey(dataId, group));
    }

    List<CacheData> getAllCacheDataSnapshot() {
        return new ArrayList<CacheData>(this.cacheMap.get().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCache(String dataId, String group) {
        String groupKey = GroupKey.getKey(dataId, group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[unsubscribe] {}", groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group);
        if (null != cache) {
            return cache;
        }
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            String key = GroupKey.getKey(dataId, group);
            cache = new CacheData(this, dataId, group);
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
            log.info(this.getName(), "[subscribe] {}", key);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group);
        cache.setContent(content);
        return cache;
    }

    public Set<String> getSubscribeDataIds() {
        Map<String, CacheData> cacheMapSnapshot = this.cacheMap.get();
        HashSet<String> dataIds = new HashSet<String>(cacheMapSnapshot.size());
        for (CacheData cache : cacheMapSnapshot.values()) {
            dataIds.add(cache.dataId);
        }
        return dataIds;
    }

    public String toString() {
        return "DiamondEnv-" + this.serverMgr.toString();
    }

    public ServerListManager getServerMgr() {
        return this.serverMgr;
    }

    public String getName() {
        return this.serverMgr.name;
    }

    public void initServerManager(ServerListManager _serverMgr) {
        _serverMgr.setEnv(this);
        this.serverMgr = _serverMgr;
        this.serverMgr.start();
        this.agent = new ServerHttpAgent(this.serverMgr);
    }

    public DiamondEnv(String ... serverIps) {
        this(new ServerListManager(Arrays.asList(serverIps)));
    }

    protected DiamondEnv(ServerListManager serverListMgr) {
        this.initServerManager(serverListMgr);
        this.cacheMap = new AtomicReference(new HashMap());
        this.worker = new ClientWorker(this);
    }
}

