/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

public class Wildcard {
    protected static final String PATH_MATCH = "**";
    protected static final String PATH_SEPARATORS = "/\\";

    public static boolean match(String string, String pattern) {
        return Wildcard.match(string, pattern, 0, 0);
    }

    public static boolean equalsOrMatch(String string, String pattern) {
        if (string.equals(pattern)) {
            return true;
        }
        return Wildcard.match(string, pattern, 0, 0);
    }

    private static boolean match(String string, String pattern, int sNdx, int pNdx) {
        int pLen = pattern.length();
        if (pLen == 1 && pattern.charAt(0) == '*') {
            return true;
        }
        int sLen = string.length();
        boolean nextIsNotWildcard = false;
        while (true) {
            if (sNdx >= sLen) {
                while (pNdx < pLen && pattern.charAt(pNdx) == '*') {
                    ++pNdx;
                }
                return pNdx >= pLen;
            }
            if (pNdx >= pLen) {
                return false;
            }
            char p = pattern.charAt(pNdx);
            if (!nextIsNotWildcard) {
                if (p == '\\') {
                    ++pNdx;
                    nextIsNotWildcard = true;
                    continue;
                }
                if (p == '?') {
                    ++sNdx;
                    ++pNdx;
                    continue;
                }
                if (p == '*') {
                    int pNext = 0;
                    if (pNdx + 1 < pLen) {
                        pNext = pattern.charAt(pNdx + 1);
                    }
                    if (pNext == 42) {
                        ++pNdx;
                        continue;
                    }
                    ++pNdx;
                    for (int i = string.length(); i >= sNdx; --i) {
                        if (!Wildcard.match(string, pattern, i, pNdx)) continue;
                        return true;
                    }
                    return false;
                }
            } else {
                nextIsNotWildcard = false;
            }
            if (p != string.charAt(sNdx)) {
                return false;
            }
            ++sNdx;
            ++pNdx;
        }
    }

    public static int matchOne(String src, String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!Wildcard.match(src, patterns[i])) continue;
            return i;
        }
        return -1;
    }

    protected static boolean matchTokens(String[] tokens, String[] patterns) {
        String patDir;
        int tokNdxStart;
        int patNdxStart = 0;
        int patNdxEnd = patterns.length - 1;
        int tokNdxEnd = tokens.length - 1;
        for (tokNdxStart = 0; patNdxStart <= patNdxEnd && tokNdxStart <= tokNdxEnd && !(patDir = patterns[patNdxStart]).equals(PATH_MATCH); ++patNdxStart, ++tokNdxStart) {
            if (Wildcard.match(tokens[tokNdxStart], patDir)) continue;
            return false;
        }
        if (tokNdxStart > tokNdxEnd) {
            for (int i = patNdxStart; i <= patNdxEnd; ++i) {
                if (patterns[i].equals(PATH_MATCH)) continue;
                return false;
            }
            return true;
        }
        if (patNdxStart > patNdxEnd) {
            return false;
        }
        while (patNdxStart <= patNdxEnd && tokNdxStart <= tokNdxEnd && !(patDir = patterns[patNdxEnd]).equals(PATH_MATCH)) {
            if (!Wildcard.match(tokens[tokNdxEnd], patDir)) {
                return false;
            }
            --patNdxEnd;
            --tokNdxEnd;
        }
        if (tokNdxStart > tokNdxEnd) {
            for (int i = patNdxStart; i <= patNdxEnd; ++i) {
                if (patterns[i].equals(PATH_MATCH)) continue;
                return false;
            }
            return true;
        }
        while (patNdxStart != patNdxEnd && tokNdxStart <= tokNdxEnd) {
            int patIdxTmp = -1;
            for (int i = patNdxStart + 1; i <= patNdxEnd; ++i) {
                if (!patterns[i].equals(PATH_MATCH)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patNdxStart + 1) {
                ++patNdxStart;
                continue;
            }
            int patLength = patIdxTmp - patNdxStart - 1;
            int strLength = tokNdxEnd - tokNdxStart + 1;
            int ndx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subStr = tokens[tokNdxStart + i + j];
                    String subPat = patterns[patNdxStart + j + 1];
                    if (!Wildcard.match(subStr, subPat)) continue block6;
                }
                ndx = tokNdxStart + i;
                break;
            }
            if (ndx == -1) {
                return false;
            }
            patNdxStart = patIdxTmp;
            tokNdxStart = ndx + patLength;
        }
        for (int i = patNdxStart; i <= patNdxEnd; ++i) {
            if (patterns[i].equals(PATH_MATCH)) continue;
            return false;
        }
        return true;
    }
}

