/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.proxy;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.remoting.ClassKey;
import com.alibaba.dts.common.domain.result.ResultCode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProxyService
implements Constants {
    private static final Log logger = LogFactory.getLog(ProxyService.class);
    public static final Map<String, Class<?>> BASE_CLASS = new HashMap();
    private final Map<ClassKey, Method> methodCache = new HashMap<ClassKey, Method>();
    private ClassLoader customerClassLoader;

    public ClassLoader getCustomerClassLoader() {
        return this.customerClassLoader;
    }

    public void setCustomerClassLoader(ClassLoader customerClassLoader) {
        this.customerClassLoader = customerClassLoader;
    }

    public static Class<?> getClass(String parameterTypeString) {
        Class<?> parameterTypeClass = BASE_CLASS.get(parameterTypeString);
        if (parameterTypeClass != null) {
            return parameterTypeClass;
        }
        try {
            return Class.forName(parameterTypeString);
        }
        catch (Throwable e) {
            logger.error((Object)("[ProxyService]: getClass error, parameterTypeString:" + parameterTypeString), e);
            return null;
        }
    }

    public <T> T proxyInterface(Class<T> interfaceClass, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, invocationHandler);
    }

    public <T> T newInstance(Class<T> classType) {
        try {
            return classType.newInstance();
        }
        catch (Throwable e) {
            logger.error((Object)("[ProxyService]: newInstance error, classType:" + classType.getName()), e);
            return null;
        }
    }

    public <T> T newInstance(String classType) {
        Class<?> type = null;
        try {
            type = this.customerClassLoader != null ? Class.forName(classType, true, this.customerClassLoader) : Class.forName(classType);
        }
        catch (Throwable e) {
            logger.error((Object)("[ProxyService]: newInstance Class.forName error, classType:" + classType), e);
            return null;
        }
        try {
            return (T)type.newInstance();
        }
        catch (Throwable e) {
            logger.error((Object)("[ProxyService]: newInstance error, classType:" + classType), e);
            return null;
        }
    }

    public Object invokeMethod(Object object, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        Method method = this.getMethod(object, methodName, parameterTypes);
        if (null == method) {
            return ResultCode.NO_SUCH_METHOD;
        }
        Object result = null;
        try {
            method.setAccessible(true);
            result = method.invoke(object, arguments);
        }
        catch (Throwable e) {
            logger.error((Object)("[invokeMethod]: error, methodName:" + methodName), e);
        }
        return result;
    }

    private Method getMethod(Object object, String methodName, Class<?>[] parameterTypes) {
        ClassKey classKey = new ClassKey(object, methodName, parameterTypes);
        Method method = this.methodCache.get(classKey);
        if (method != null) {
            return method;
        }
        method = this.tryFindMethod(object, methodName, parameterTypes);
        if (method != null) {
            this.methodCache.put(classKey, method);
        }
        return method;
    }

    private Method tryFindMethod(Object object, String methodName, Class<?>[] parameterTypes) {
        Method method = null;
        try {
            method = object.getClass().getDeclaredMethod(methodName, parameterTypes);
        }
        catch (Throwable e) {
            logger.error((Object)("[tryFindMethod]: failed, methodName:" + methodName), e);
        }
        return method;
    }

    public Type[] aquireInterface(Object object) {
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (Class<?> classType = object.getClass(); classType != null; classType = classType.getSuperclass()) {
            this.aquireTypes(typeList, classType);
        }
        if (typeList.isEmpty()) {
            return new Type[0];
        }
        Type[] typeArray = new Type[typeList.size()];
        typeList.toArray(typeArray);
        return typeArray;
    }

    private void aquireTypes(List<Type> typeList, Class<?> classType) {
        Type[] interfaceTypes = classType.getGenericInterfaces();
        Type superClassType = classType.getGenericSuperclass();
        if (interfaceTypes != null && interfaceTypes.length > 0) {
            for (int i = 0; i < interfaceTypes.length; ++i) {
                typeList.add(interfaceTypes[i]);
            }
        }
        if (superClassType != null && !superClassType.equals(Object.class)) {
            typeList.add(superClassType);
        }
    }

    static {
        BASE_CLASS.put("double", Double.TYPE);
        BASE_CLASS.put("long", Long.TYPE);
        BASE_CLASS.put("float", Float.TYPE);
        BASE_CLASS.put("int", Integer.TYPE);
        BASE_CLASS.put("short", Short.TYPE);
        BASE_CLASS.put("char", Character.TYPE);
        BASE_CLASS.put("byte", Byte.TYPE);
        BASE_CLASS.put("boolean", Boolean.TYPE);
        BASE_CLASS.put("void", Void.TYPE);
    }
}

