/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.security;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.SpasSdkClientFacade;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.Credentials;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.sign.SpasSigner;

public class SdkSecurityCheck
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SdkSecurityCheck.class);
    private static Credentials credentials = SpasSdkClientFacade.getCredential();
    private String accessKey;
    private String secretKey;

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void init() throws InitException {
        if (credentials.getAccessKey() == null || credentials.getSecretKey() == null) {
            throw new InitException("[SdkSecurityCheck]: AK or SK is Null!");
        }
        this.setAccessKey(credentials.getAccessKey());
        this.setSecretKey(credentials.getSecretKey());
    }

    public String getSignatureStr(long connectTime, String groupid) {
        if (credentials.getAccessKey() == null || credentials.getSecretKey() == null) {
            return "Invalid AKSK";
        }
        String signdata = groupid + connectTime;
        String sign = SpasSigner.sign(signdata, credentials.getSecretKey());
        return sign;
    }
}

