/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.remoting;

import com.alibaba.dts.client.executor.grid.timer.HealthChecker;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.remoting.processor.ClientRequestProcessor;
import com.alibaba.dts.client.remoting.proxy.ClientInvocationHandler;
import com.alibaba.dts.client.remoting.proxy.ClientSystemInvocationHandler;
import com.alibaba.dts.client.remoting.timer.DtsClientHeartBeatTimer;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.exception.RemotingConnectException;
import com.alibaba.dts.common.exception.RemotingSendRequestException;
import com.alibaba.dts.common.exception.RemotingTimeoutException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.remoting.netty.NettyClientConfig;
import com.alibaba.dts.common.remoting.netty.NettyRemotingClient;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.service.ServerService;
import com.alibaba.dts.common.service.ServerSystemService;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.shade.io.netty.channel.Channel;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.util.CollectionUtils;

public class ClientRemoting
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ClientRemoting.class);
    private NettyRemotingClient client = null;
    private ScheduledExecutorService dtsTimerService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            ++this.index;
            return new Thread(runnable, "DTS-heart-beat-thread-" + this.index);
        }
    });
    private final InvocationHandler invocationHandler;
    private final InvocationHandler systemInvocationHandler;
    private final ServerService serverService;
    private final ServerSystemService serverSystemService;
    private volatile List<String> serverListCache;
    private volatile List<String> systemServerListCache;
    private final ClientContextImpl clientContext;

    public ClientRemoting(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
        this.invocationHandler = new ClientInvocationHandler(this.clientContext);
        this.serverService = this.proxyInterface(ServerService.class);
        this.systemInvocationHandler = new ClientSystemInvocationHandler(this.clientContext);
        this.serverSystemService = this.proxyInterface(ServerSystemService.class, this.systemInvocationHandler);
    }

    public void init() throws InitException {
        this.initRemotingClient();
        this.initConnection();
        this.initHeartBeatTimer();
    }

    private void initRemotingClient() throws InitException {
        NettyClientConfig config = new NettyClientConfig();
        ClientRequestProcessor processor = new ClientRequestProcessor(this.clientContext);
        this.client = new NettyRemotingClient(config);
        this.client.registerProcessor(0, processor, Executors.newFixedThreadPool(this.clientContext.getClientConfig().getRemotingThreads(), new ThreadFactory(){
            int index = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                ++this.index;
                Thread thread = new Thread(runnable, "DTS-remoting-thread-" + this.index);
                thread.setPriority(10);
                return thread;
            }
        }));
        try {
            this.client.start();
        }
        catch (Throwable e) {
            throw new InitException("[ClientRemoting]: initRemotingClient error", e);
        }
    }

    private void initConnection() throws InitException {
        List<String> serverList = this.getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.warn("[ClientRemoting]: initConnection error, serverList is empty");
            return;
        }
        for (String server : serverList) {
            this.connectServer(server);
        }
    }

    public boolean connectServer(String server) throws InitException {
        long connectTime = System.currentTimeMillis();
        this.clientContext.getClientConfig().setConnectTime(connectTime);
        this.clientContext.getClientConfig().setSignature(this.clientContext.getSecurityCheck().getSignatureStr(connectTime));
        if ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment()) && this.clientContext.getClientConfig().getAccessKey() == null) {
            throw new InitException("[ClientRemoting]: AK  is Null!");
        }
        RemoteMachine remoteMachine = new RemoteMachine(server);
        remoteMachine.setH2Alive(HealthChecker.h2Alive.get());
        InvocationContext.setRemoteMachine(remoteMachine);
        Result<Boolean> connectResult = this.serverService.connect(StringUtil.isBlank(this.clientContext.getClientConfig().getAccessKey()) ? "NULL" : this.clientContext.getClientConfig().getAccessKey());
        if (null == connectResult) {
            logger.warn("[ClientRemoting]: connectServer failed, connectResult is null, machineGroup:" + this.clientContext.getClientConfig().getGroupId() + ", server:" + server);
            return false;
        }
        if (!connectResult.getData().booleanValue()) {
            logger.warn("[ClientRemoting]: connectServer failed, connectResult:" + connectResult.toString() + ", machineGroup:" + this.clientContext.getClientConfig().getGroupId() + ", server:" + server + ",resp:" + connectResult.getResultCode().getInformation());
            throw new InitException("[ClientRemoting]: connectServer error," + connectResult.getResultCode().getInformation());
        }
        return true;
    }

    public List<String> getServerList() {
        if (CollectionUtils.isEmpty(this.serverListCache)) {
            this.serverListCache = this.clientContext.getZookeeper().getServerList();
        }
        return this.serverListCache;
    }

    public List<String> getSystemServerList() {
        if (CollectionUtils.isEmpty(this.systemServerListCache)) {
            this.systemServerListCache = this.clientContext.getZookeeper().getSystemServerList();
        }
        return this.systemServerListCache;
    }

    private void initHeartBeatTimer() throws InitException {
        try {
            this.dtsTimerService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
                int index = 0;

                @Override
                public Thread newThread(Runnable runnable) {
                    ++this.index;
                    return new Thread(runnable, "DTS-heart-beat-thread-" + this.index);
                }
            });
            this.dtsTimerService.scheduleAtFixedRate(new DtsClientHeartBeatTimer(this.clientContext), 0L, 10000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new InitException("[ClientRemoting]: initHeartBeatTimer error, heartBeatIntervalTime:" + this.clientContext.getClientConfig().getHeartBeatIntervalTime(), e);
        }
        logger.warn("[ClientRemoting]: initHeartBeatTimer success, heartBeatIntervalTime:" + this.clientContext.getClientConfig().getHeartBeatIntervalTime());
    }

    public <T> T proxyInterface(Class<T> interfaceClass) {
        return this.clientContext.getProxyService().proxyInterface(interfaceClass, this.invocationHandler);
    }

    public <T> T proxyInterface(Class<T> interfaceClass, InvocationHandler invocationHandler) {
        return this.clientContext.getProxyService().proxyInterface(interfaceClass, invocationHandler);
    }

    public Channel getAndCreateChannel(String addr) throws InterruptedException {
        return this.client.getAndCreateChannel(addr);
    }

    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        return this.client.invokeSync(addr, request, timeoutMillis);
    }

    public AtomicLong getCounter(ConcurrentHashMap<String, AtomicLong> heartBeatCounter, String key) {
        AtomicLong existCounter;
        AtomicLong counter = heartBeatCounter.get(key);
        if (null == counter && (existCounter = heartBeatCounter.putIfAbsent(key, counter = new AtomicLong(0L))) != null) {
            counter = existCounter;
        }
        return counter;
    }

    public void setServerListCache(List<String> serverListCache) {
        this.serverListCache = serverListCache;
    }

    public void setSystemServerListCache(List<String> serverListCache) {
        this.systemServerListCache = serverListCache;
    }

    public ServerSystemService getServerSystemService() {
        return this.serverSystemService;
    }

    public void stopService() {
        this.dtsTimerService.shutdownNow();
        this.client.shutdown();
    }
}

