/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.logger.timer;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.FileUtil;
import com.alibaba.dts.common.util.PathUtil;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.CollectionUtils;

public class CleanLogTimer
extends TimerTask {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(CleanLogTimer.class);

    @Override
    public void run() {
        AtomicInteger fileCounter = new AtomicInteger(0);
        try {
            String loggerRootPath = PathUtil.getHomeLoggerRootPath();
            List<String> fileList = FileUtil.getFileList(loggerRootPath);
            if (CollectionUtils.isEmpty(fileList)) {
                return;
            }
            for (String file : fileList) {
                this.handleDir(file, fileCounter);
            }
        }
        catch (Throwable e) {
            logger.error("[CleanLogTimer]: run error", e);
        }
        logger.warn("[CleanLogTimer]: run over, fileCounter:" + fileCounter.get());
    }

    private void handleDir(String dir, AtomicInteger fileCounter) {
        String loggerTaskPath = PathUtil.getHomeLoggerTaskPath(Long.parseLong(dir));
        List<String> fileList = FileUtil.getFileList(loggerTaskPath);
        if (CollectionUtils.isEmpty(fileList) || fileList.size() <= 1000) {
            return;
        }
        Collections.sort(fileList);
        int i = 0;
        for (String file : fileList) {
            if (i < fileList.size() - 1000) {
                String loggerPath = PathUtil.getHomeLoggerPath(Long.parseLong(dir), file);
                FileUtil.deleteFile(loggerPath);
                fileCounter.incrementAndGet();
            }
            ++i;
        }
    }
}

