/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.logger;

import com.alibaba.dts.client.logger.timer.CleanLogTimer;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.DtsLogger;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ExecuteLogger {
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "DTS-Clean-Log-thread");
        }
    });

    public void init() throws InitException {
        this.initCleanLogTimer();
    }

    public void initCleanLogTimer() throws InitException {
        try {
            this.executorService.scheduleAtFixedRate(new CleanLogTimer(), 0L, 300000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new InitException("[ExecuteLogger]: initCleanLogTimer error", e);
        }
    }

    public List<String> readLog(long jobId, long instanceId) {
        return DtsLogger.read(jobId, instanceId);
    }
}

