/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.script;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;

public class ShellUtils {
    private static final Logger LOGGER = SchedulerXLoggerFactory.getLogger(ShellUtils.class);

    public static ProcessBuilder createProcessBuilder(String cmd) {
        return new ProcessBuilder("/bin/sh", "-c", cmd);
    }

    public static BufferedReader executeShell(String cmd) throws IOException {
        return ShellUtils.executeShell(cmd, -1L);
    }

    public static BufferedReader executeShell(String cmd, long timeout) throws IOException {
        try {
            ProcessBuilder pb = ShellUtils.createProcessBuilder(cmd);
            Process p = pb.start();
            int exitCode = p.waitFor();
            InputStream inputStream = p.getErrorStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            if (exitCode != 0) {
                String line;
                StringBuilder stdError = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    stdError.append(line);
                }
                throw new IOException(stdError.toString());
            }
            return br;
        }
        catch (Exception e) {
            LOGGER.error("", e);
            throw new IOException(e);
        }
    }

    public static long getPidOfProcess(Process p) {
        long pid = -1L;
        try {
            if (p.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getLong(p);
                f.setAccessible(false);
            }
        }
        catch (Exception e) {
            pid = -1L;
        }
        return pid;
    }

    public static void killProcess(long pid) throws IOException {
        if (pid != -1L) {
            ShellUtils.executeShell("kill -9 " + pid, 60L);
        }
    }
}

