/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.script;

import com.alibaba.dts.client.executor.job.processor.ExSimpleJobProcessor;
import com.alibaba.dts.client.executor.logcollector.AbstractLogCollector;
import com.alibaba.dts.client.executor.logcollector.StreamType;
import com.alibaba.dts.client.executor.script.ShellStreamProcessor;
import com.alibaba.dts.client.executor.script.ShellUtils;
import com.alibaba.dts.client.executor.simple.processor.SimpleJobContext;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.edas.schedulerx.ProcessResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;

public class ShellJobProcessor
extends ExSimpleJobProcessor {
    private static final Logger LOGGER = SchedulerXLoggerFactory.getLogger(ShellJobProcessor.class);
    private Process shellProcess = null;
    private AbstractLogCollector logCollector = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessResult process(SimpleJobContext context) {
        boolean result = false;
        try {
            ProcessBuilder processBuilder = ShellUtils.createProcessBuilder(this.getContext(context));
            if (this.redirectStream()) {
                processBuilder.redirectErrorStream(true);
            }
            this.shellProcess = processBuilder.start();
            CountDownLatch countDownLatch = null;
            if (this.redirectStream()) {
                countDownLatch = new CountDownLatch(1);
                ShellStreamProcessor stderrStreamProcessor = new ShellStreamProcessor(this, this.shellProcess.getInputStream(), StreamType.STD_ERR, countDownLatch);
                stderrStreamProcessor.start();
            } else {
                countDownLatch = new CountDownLatch(2);
                ShellStreamProcessor stdoutStreamProcessor = new ShellStreamProcessor(this, this.shellProcess.getInputStream(), StreamType.STD_OUT, countDownLatch);
                stdoutStreamProcessor.start();
                ShellStreamProcessor stderrStreamProcessor = new ShellStreamProcessor(this, this.shellProcess.getErrorStream(), StreamType.STD_ERR, countDownLatch);
                stderrStreamProcessor.start();
            }
            countDownLatch.await();
            result = this.shellProcess.waitFor() == 0;
            return result;
        }
        catch (Exception e) {
            this.logCollector.collectStderr(e.getMessage());
        }
        finally {
            return new ProcessResult(result);
        }
    }

    protected String getContext(SimpleJobContext context) {
        return context.getJob().getJobArguments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStdOutputStream(InputStream inputStream) {
        String line = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                this.logCollector.collectStdout(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("error ShellJobProcessor stdout stream", e);
        }
        finally {
            this.logCollector.collectStdout("", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStdErrorStream(InputStream inputStream) {
        String line = null;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                this.logCollector.collectStderr(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("error ShellJobProcessor stderr stream", e);
        }
        finally {
            this.logCollector.collectStderr("", true);
        }
    }

    protected boolean redirectStream() {
        return false;
    }

    @Override
    public boolean kill() {
        boolean result = true;
        try {
            ShellUtils.killProcess(ShellUtils.getPidOfProcess(this.shellProcess));
        }
        catch (Exception e) {
            result = false;
        }
        if (this.shellProcess != null) {
            this.shellProcess.destroy();
        }
        return result;
    }

    @Override
    public void preProcess(SimpleJobContext context) {
        this.logCollector = context.getLogCollector();
    }

    @Override
    public void postProcess(SimpleJobContext context) {
    }
}

