/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.longtime.unit;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.longtime.LongTimePool;
import com.alibaba.dts.client.executor.longtime.unit.ExecutorUnit;
import com.alibaba.dts.client.executor.longtime.unit.TaskRunStatistic;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class StatesReportTimer
extends TimerTask {
    private final ExecutorUnit executorUnit;
    private final ClientContextImpl clientContext;
    private static final long TASK_CHECK_PERIOD = 120000L;
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(StatesReportTimer.class);

    public StatesReportTimer(ExecutorUnit executorUnit, ClientContextImpl clientContext) {
        this.executorUnit = executorUnit;
        this.clientContext = clientContext;
    }

    @Override
    public void run() {
        try {
            Result<JobInstanceSnapshot> jobInstanceStates = this.clientContext.getExecutor().getJobInstanceById(this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
            if (jobInstanceStates != null && jobInstanceStates.getResultCode() == ResultCode.SUCCESS) {
                if (null == jobInstanceStates.getData() || 2 != jobInstanceStates.getData().getStatus()) {
                    LongTimePool longTimePool = this.executorUnit.getLongTimePool();
                    longTimePool.stopTask(this.executorUnit.getExecutableTask().getJob().getId(), this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
                    this.executorUnit.stopTask();
                    logger.warn("[StatesReportTimer]: current jobInstance has been stop, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
                } else {
                    Result<Boolean> taskStatesReportResult = null;
                    List<Long> ids = this.getIdList(this.executorUnit.getTaskRunStatisticMap());
                    if (ids == null || ids.isEmpty()) {
                        logger.warn("TaskRunStatisticMap is empty, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
                    } else {
                        taskStatesReportResult = this.clientContext.getExecutor().taskStatesReport(this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), ids);
                        if (null == taskStatesReportResult || !taskStatesReportResult.getData().booleanValue()) {
                            logger.warn("[StatesReportTimer]: taskStatesReport error, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() + ", ids:" + ids + ", taskStatesReportResult:" + taskStatesReportResult);
                        } else {
                            logger.info("[StatesReportTimer]: taskStatesReport successful, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() + ", ids:" + ids + ", taskStatesReportResult:" + taskStatesReportResult);
                        }
                    }
                    logger.info("[StatesReportTimer]: current statistic detail, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() + ", current queue size:" + this.executorUnit.getQueue().size() + ", current queue:" + this.getQueueTaskid(this.executorUnit.getQueue()) + ", current completed queue size:" + this.executorUnit.getCompletedqueue().size() + ", current completed queue:" + this.getQueueTaskid(this.executorUnit.getCompletedqueue()) + ", current taskRunStatisticMap size:" + this.executorUnit.getTaskRunStatisticMap().size() + ", current taskRunStatisticMap:" + this.executorUnit.getTaskRunStatisticMapStr());
                }
            } else {
                LongTimePool longTimePool = this.executorUnit.getLongTimePool();
                longTimePool.stopTask(this.executorUnit.getExecutableTask().getJob().getId(), this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
                this.executorUnit.stopTask();
                logger.warn("[StatesReportTimer]: current jobInstance has been stop, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
            }
        }
        catch (Throwable e) {
            logger.error("[StatesReportTimer]: taskStatesReport error, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
        }
    }

    private String getQueueTaskid(BlockingQueue<TaskSnapshot> taskSnapshots) {
        StringBuffer ids = new StringBuffer();
        try {
            TaskSnapshot[] taskSnapshotArrayList = null;
            if (taskSnapshots != null) {
                taskSnapshotArrayList = new TaskSnapshot[taskSnapshots.size()];
                taskSnapshots.toArray(taskSnapshotArrayList);
            }
            ids.append("[");
            if (taskSnapshotArrayList != null) {
                for (int i = 0; i < taskSnapshotArrayList.length; ++i) {
                    ids.append("," + taskSnapshotArrayList[i].getId());
                }
            }
            ids.append("]");
        }
        catch (Throwable e) {
            logger.error("[StatesReportTimer]: getQueueTaskid error, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
        }
        return ids.toString();
    }

    private List<Long> getIdList(ConcurrentHashMap<Long, TaskRunStatistic> taskSnapshotList) {
        ArrayList<Long> result = null;
        try {
            if (taskSnapshotList == null || taskSnapshotList.isEmpty()) {
                return null;
            }
            result = new ArrayList<Long>();
            Iterator<Map.Entry<Long, TaskRunStatistic>> iterator = taskSnapshotList.entrySet().iterator();
            while (iterator.hasNext()) {
                try {
                    Date now = new Date();
                    Date checkTime = new Date(now.getTime() - 120000L);
                    Map.Entry<Long, TaskRunStatistic> entry = iterator.next();
                    Long taskid = entry.getKey();
                    TaskRunStatistic taskRunStatistic = entry.getValue();
                    if (taskRunStatistic != null && taskRunStatistic.getLastRunTime().compareTo(checkTime) > 0) {
                        result.add(taskid);
                        continue;
                    }
                    logger.warn("[StatesReportTimer]: task lastRunTimeout, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() + ", checkTime:" + checkTime + ", lastRunTime:" + taskRunStatistic.getLastRunTime() + ", taskid:" + taskid);
                }
                catch (Throwable e) {
                    logger.error("[StatesReportTimer]: getIdList error, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
                }
            }
        }
        catch (Throwable e) {
            logger.error("[StatesReportTimer]: getIdList error, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
        }
        return result;
    }
}

