/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.logcollector;

import com.alibaba.dts.client.executor.logcollector.AbstractLogCleaner;
import com.alibaba.dts.client.executor.logcollector.LocalLogCollector;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.shade.org.joda.time.DateTime;
import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LocalLogCleaner
extends AbstractLogCleaner {
    private static final Logger LOGGER = SchedulerXLoggerFactory.getLogger(LocalLogCleaner.class);
    private static final int CLEAN_DAYS_BEFORE = 7;
    private ScheduledExecutorService logCleanES = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            ++this.index;
            return new Thread(runnable, "DTS-LOCAL_LOG_CLEANER-thread-" + this.index);
        }
    });

    @Override
    public void init() {
        this.logCleanES.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DateTime now = DateTime.now();
                try {
                    File file = new File(LocalLogCollector.DIR_PREFIX);
                    if (file.exists()) {
                        File[] children;
                        for (File child : children = file.listFiles()) {
                            DateTime dt = new DateTime(child.getName());
                            if (!dt.isBefore(now.withTimeAtStartOfDay().minusDays(7))) continue;
                            LocalLogCleaner.deleteAllFilesOfDir(child);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error("[LocalLogCleaner] log clean error: ", e);
                }
            }
        }, 300L, 86400L, TimeUnit.SECONDS);
        LOGGER.info("[LocalLogCleaner] stared.");
    }

    public static void deleteAllFilesOfDir(File path) {
        File[] files;
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            path.delete();
            return;
        }
        for (File file : files = path.listFiles()) {
            LocalLogCleaner.deleteAllFilesOfDir(file);
        }
        path.delete();
    }
}

