/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.flowcontrol;

import com.alibaba.dts.client.executor.grid.flowcontrol.FlowControl;
import com.alibaba.dts.client.executor.grid.flowcontrol.FlowControlParameterWatcher;
import com.alibaba.dts.client.executor.grid.flowcontrol.FlowControlStrategy;
import com.alibaba.dts.client.executor.grid.flowcontrol.H2CountOneFlowControl;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FlowControlChain {
    private ClientContextImpl clientContext;
    private List<FlowControl> flowControls = new ArrayList<FlowControl>();
    private Map<String, FlowControl> flowControlMap = new ConcurrentHashMap<String, FlowControl>();

    public FlowControlChain(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() {
        FlowControlStrategy flowControlStrategy = this.clientContext.getNodeConfig().getFlowControlStrategy();
        FlowControlParameterWatcher watcher = new FlowControlParameterWatcher(this.clientContext);
        watcher.watchH2Count();
        H2CountOneFlowControl h2Count = new H2CountOneFlowControl(this.clientContext);
        if (this.clientContext.getNodeConfig().getFlowControlStrategyMap() != null) {
            for (Map.Entry<String, FlowControlStrategy> jobProcessorFlowControlStrategy : this.clientContext.getNodeConfig().getFlowControlStrategyMap().entrySet()) {
                String jobProcessor = jobProcessorFlowControlStrategy.getKey();
                FlowControlStrategy flowControlStrategyTemp = jobProcessorFlowControlStrategy.getValue();
                if (flowControlStrategyTemp != FlowControlStrategy.H2_COUNT_ONE && flowControlStrategyTemp != FlowControlStrategy.H2_COUNT) continue;
                this.flowControlMap.put(jobProcessor, h2Count);
            }
        }
        if (flowControlStrategy == FlowControlStrategy.NONE) {
            return;
        }
        if (flowControlStrategy == FlowControlStrategy.H2_COUNT_ONE || flowControlStrategy == FlowControlStrategy.H2_COUNT) {
            this.addLast(h2Count);
        }
    }

    public void control(JobContext jobContext) {
        String jobProcessor = jobContext.getJob().getJobProcessor();
        FlowControl flowControl = this.flowControlMap.get(jobProcessor);
        if (flowControl != null) {
            flowControl.pass(jobContext);
        } else {
            for (FlowControl flowControl2 : this.flowControls) {
                flowControl2.pass(jobContext);
            }
        }
    }

    public void addLast(FlowControl flowControl) {
        this.flowControls.add(flowControl);
    }

    public List<FlowControl> getFlowControls() {
        return this.flowControls;
    }

    public void setFlowControls(List<FlowControl> flowControls) {
        this.flowControls = flowControls;
    }
}

