/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid;

import com.alibaba.dts.client.executor.grid.timer.JobInstanceMapCleaner;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.concurrent.ConcurrentHashMap;

public class GridJobManager {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(GridJobManager.class);
    private volatile ConcurrentHashMap<Long, Long> interruptedJobInstanceMap = new ConcurrentHashMap();
    private JobInstanceMapCleaner jobInstanceMapCleaner;
    private ClientContextImpl clientContext;

    public GridJobManager(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public ConcurrentHashMap<Long, Long> getInterruptedJobInstanceMap() {
        return this.interruptedJobInstanceMap;
    }

    public boolean addInterruptedJobInstance(long jobInstanceId) {
        this.interruptedJobInstanceMap.putIfAbsent(jobInstanceId, System.currentTimeMillis());
        logger.info("[GridJobManager]: addInterruptedInstance instanceId:" + jobInstanceId);
        return true;
    }

    public boolean containsInterruptedJobInstance(long jobInstanceId) {
        return this.interruptedJobInstanceMap.containsKey(jobInstanceId);
    }

    public boolean removeInterruptedJobInstance(long jobInstanceId) {
        this.interruptedJobInstanceMap.remove(jobInstanceId);
        logger.info("[GridJobManager]: removeInterceptInstance instanceId=" + jobInstanceId);
        return true;
    }

    public void init() {
        this.jobInstanceMapCleaner = new JobInstanceMapCleaner(this.clientContext);
        this.jobInstanceMapCleaner.init();
    }
}

