/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.shade.com.ali.dpath.DPath;
import com.alibaba.dts.shade.com.ali.dpath.DPathRuleListener;
import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.UUID;

public class DPathListener
implements DPathRuleListener,
Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DPathListener.class);
    private ClientContextImpl clientContext;
    private static final String FAIL_MSG = "\u673a\u5668ip: {0}\uff0c \u73af\u5883\u6807\u7b7e: {1},  groupId: {2}\uff0c\u5728\u6267\u884c\u84dd\u7eff\u53d1\u5e03\u7684\u8fc7\u7a0b\u4e2d\uff0cschedulerx\u7f6e\u6362\u76f8\u5e94\u5206\u7ec4\u8fc7\u7a0b\u4e2d\u6709\u5f02\u5e38\u51fa\u73b0\u3002\u8bf7\u624b\u52a8\u91cd\u542f\u8be5\u673a\u5668\u53ef\u89e3\u51b3\u6216\u8054\u7cfbschedulerx\u503c\u73ed\u89e3\u51b3";

    public DPathListener(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public void onChanged(String s) {
        String clientIp = RemotingUtil.getLocalAddress();
        String curMachineEnv = DPath.envOf(this.clientContext.getClientConfig().getMachineGroup(), clientIp);
        String groupId = "";
        String orgMachineEnv = this.clientContext.getClientConfig().getMachineEnv();
        logger.warn("[DPathListener]curMachineEnv: " + curMachineEnv + " orgMachineEnv: " + orgMachineEnv + " ip: " + clientIp + " machineGroup: " + this.clientContext.getClientConfig().getMachineGroup());
        if (StringUtils.isNotBlank(curMachineEnv) && StringUtils.isNotBlank(orgMachineEnv) && !curMachineEnv.equals(orgMachineEnv)) {
            if (!"DPathBaseEnv".equals(curMachineEnv)) {
                try {
                    groupId = this.clientContext.getClientConfig().calculateRealGroupIdForDeploy(this.clientContext.getClientConfig().getOrgGroupId(), curMachineEnv);
                    this.clientContext.getClientConfig().setBlueGreenGroupId(groupId);
                }
                catch (InitException e) {
                    logger.warn("[DPathListener]first calculateRealGroupIdForDeploy error. ip: " + clientIp + " machineGroup: " + this.clientContext.getClientConfig().getMachineGroup() + " env: " + curMachineEnv + " groupId: " + groupId, e);
                    try {
                        groupId = this.clientContext.getClientConfig().calculateRealGroupIdForDeploy(this.clientContext.getClientConfig().getOrgGroupId(), curMachineEnv);
                        this.clientContext.getClientConfig().setBlueGreenGroupId(groupId);
                    }
                    catch (InitException e1) {
                        logger.warn("[DPathListener]retry calculateRealGroupIdForDeploy error. ip: " + clientIp + " env: " + curMachineEnv + " groupId: " + groupId, e1);
                        this.sendWarnMsg(this.clientContext.getClientConfig().getOrgGroupId(), curMachineEnv, clientIp);
                    }
                }
            } else {
                groupId = this.clientContext.getClientConfig().getOrgGroupId();
            }
            if (StringUtils.isNotBlank(groupId)) {
                boolean chageResult = true;
                try {
                    this.processChangeGroup(groupId);
                }
                catch (Throwable e) {
                    logger.warn("[DPathListener]first processChangeGroup fail.", e);
                    try {
                        this.processChangeGroup(groupId);
                    }
                    catch (Throwable e1) {
                        chageResult = false;
                        logger.warn("[DPathListener]retry processChangeGroup fail.", e1);
                    }
                }
                if (!chageResult) {
                    logger.warn("[DPathListener]processChangeGroup fail, ip: " + clientIp + " env: " + curMachineEnv + " machineGroup: " + this.clientContext.getClientConfig().getMachineGroup() + " groupId: " + groupId);
                    this.sendWarnMsg(this.clientContext.getClientConfig().getOrgGroupId(), curMachineEnv, clientIp);
                } else {
                    this.clientContext.getClientConfig().setMachineEnv(curMachineEnv);
                    logger.warn("[DPathListener]processChangeGroup success, orgMachineEnv: " + orgMachineEnv + " curMachineEnv:" + curMachineEnv + " curGroupId: " + groupId + " machineGroup: " + this.clientContext.getClientConfig().getMachineGroup());
                }
            }
        }
    }

    private void processChangeGroup(String groupId) throws Exception {
        this.clientContext.getClientRemoting().stopService();
        Thread.sleep(6000L);
        boolean stop = this.clientContext.getExecutor().getLongTimePool().stopService();
        if (!stop) {
            logger.warn("[DPathListener] stop long time fail.");
            throw new Exception("stop long time fail!");
        }
        logger.warn("[DPathListener] stop long time success.");
        this.clientContext.getClientConfig().setGroupId(groupId);
        this.clientContext.getNodeConfig().setGroupId(groupId);
        String localAddress = RemotingUtil.getLocalAddress();
        String clientId = UUID.randomUUID().toString() + ":" + localAddress;
        this.clientContext.getClientConfig().setClientId(clientId);
        this.clientContext.getClientRemoting().init();
    }

    private void sendWarnMsg(String groupId, String machineEnv, String clientIp) {
        String message = MessageFormat.format(FAIL_MSG, clientIp, machineEnv, groupId);
        String dtsConsoleUrl = "http://" + this.clientContext.getClientConfig().getDomainName() + "/dts-console/apiManager.do?action=ApiAction&event_submit_do_send_warn_msg=1&message=" + URLEncoder.encode(message) + "&groupId=" + groupId + "&source=bluegreen";
        String response = this.clientContext.getHttpService().request(dtsConsoleUrl).getValue();
        logger.info("[DPathListener]sendWarnMsg, response: " + response);
        if (response != null) {
            JSONObject result = JSON.parseObject((String)response);
            if (result != null && !Boolean.parseBoolean(result.getString("success"))) {
                logger.warn("[DPathListener] sendWarnMsg error, groupId: " + groupId + " message:" + message);
            } else {
                logger.warn("[DPathListener] sendWarnMsg success, groupId: " + groupId + " message:" + message);
            }
        }
    }
}

