/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropForeignKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropIndex;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRename;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableRenameColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateStatement;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUniqueConstraint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.ListDG;
import com.alibaba.druid.util.lang.Consumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SQLCreateTableStatement
extends SQLStatementImpl
implements SQLDDLStatement,
SQLCreateStatement {
    protected boolean ifNotExiists = false;
    protected Type type;
    protected SQLExprTableSource tableSource;
    protected List<SQLTableElement> tableElementList = new ArrayList<SQLTableElement>();
    private SQLExprTableSource inherits;
    protected SQLSelect select;
    protected SQLExpr comment;
    protected SQLExprTableSource like;

    public SQLCreateTableStatement() {
    }

    public SQLCreateTableStatement(String dbType) {
        super(dbType);
    }

    public SQLExpr getComment() {
        return this.comment;
    }

    public void setComment(SQLExpr comment) {
        if (comment != null) {
            comment.setParent(this);
        }
        this.comment = comment;
    }

    public SQLName getName() {
        if (this.tableSource == null) {
            return null;
        }
        return (SQLName)this.tableSource.getExpr();
    }

    public String getSchema() {
        SQLName name = this.getName();
        if (name == null) {
            return null;
        }
        if (name instanceof SQLPropertyExpr) {
            return ((SQLPropertyExpr)name).getOwnernName();
        }
        return null;
    }

    public void setSchema(String name) {
        if (this.tableSource == null) {
            return;
        }
        this.tableSource.setSchema(name);
    }

    public void setName(SQLName name) {
        this.setTableSource(new SQLExprTableSource(name));
    }

    public void setName(String name) {
        this.setName(new SQLIdentifierExpr(name));
    }

    public SQLExprTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(SQLExprTableSource tableSource) {
        if (tableSource != null) {
            tableSource.setParent(this);
        }
        this.tableSource = tableSource;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<SQLTableElement> getTableElementList() {
        return this.tableElementList;
    }

    public boolean isIfNotExiists() {
        return this.ifNotExiists;
    }

    public void setIfNotExiists(boolean ifNotExiists) {
        this.ifNotExiists = ifNotExiists;
    }

    public SQLExprTableSource getInherits() {
        return this.inherits;
    }

    public void setInherits(SQLExprTableSource inherits) {
        if (inherits != null) {
            inherits.setParent(this);
        }
        this.inherits = inherits;
    }

    public SQLSelect getSelect() {
        return this.select;
    }

    public void setSelect(SQLSelect select) {
        if (select != null) {
            select.setParent(this);
        }
        this.select = select;
    }

    public SQLExprTableSource getLike() {
        return this.like;
    }

    public void setLike(SQLName like) {
        this.setLike(new SQLExprTableSource(like));
    }

    public void setLike(SQLExprTableSource like) {
        if (like != null) {
            like.setParent(this);
        }
        this.like = like;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.tableElementList);
            this.acceptChild(visitor, this.inherits);
            this.acceptChild(visitor, this.select);
        }
        visitor.endVisit(this);
    }

    public void addBodyBeforeComment(List<String> comments) {
        List attrComments;
        if (this.attributes == null) {
            this.attributes = new HashMap(1);
        }
        if ((attrComments = (List)this.attributes.get("format.body_before_comment")) == null) {
            this.attributes.put("format.body_before_comment", comments);
        } else {
            attrComments.addAll(comments);
        }
    }

    public List<String> getBodyBeforeCommentsDirect() {
        if (this.attributes == null) {
            return null;
        }
        return (List)this.attributes.get("format.body_before_comment");
    }

    public boolean hasBodyBeforeComment() {
        List<String> comments = this.getBodyBeforeCommentsDirect();
        if (comments == null) {
            return false;
        }
        return !comments.isEmpty();
    }

    public String computeName() {
        if (this.tableSource == null) {
            return null;
        }
        SQLExpr expr = this.tableSource.getExpr();
        if (expr instanceof SQLName) {
            String name = ((SQLName)expr).getSimpleName();
            return SQLUtils.normalize(name);
        }
        return null;
    }

    public SQLColumnDefinition findColumn(String columName) {
        if (columName == null) {
            return null;
        }
        long hash = FnvHash.hashCode64(columName);
        return this.findColumn(hash);
    }

    public SQLColumnDefinition findColumn(long columName_hash) {
        for (SQLTableElement element : this.tableElementList) {
            SQLColumnDefinition column;
            SQLName columnName;
            if (!(element instanceof SQLColumnDefinition) || (columnName = (column = (SQLColumnDefinition)element).getName()) == null || columnName.nameHashCode64() != columName_hash) continue;
            return column;
        }
        return null;
    }

    public boolean isPrimaryColumn(String columnName) {
        SQLPrimaryKey pk = this.findPrimaryKey();
        if (pk == null) {
            return false;
        }
        return pk.containsColumn(columnName);
    }

    public boolean isMUL(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            SQLExpr column;
            MySqlKey unique;
            if (element instanceof MySqlUnique) {
                unique = (MySqlUnique)element;
                column = unique.getColumns().get(0).getExpr();
                if (column instanceof SQLIdentifierExpr && SQLUtils.nameEquals(columnName, ((SQLIdentifierExpr)column).getName())) {
                    return ((MySqlUnique)unique).columns.size() > 1;
                }
                if (!(column instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)column).getMethodName(), columnName)) continue;
                return true;
            }
            if (!(element instanceof MySqlKey)) continue;
            unique = (MySqlKey)element;
            column = unique.getColumns().get(0).getExpr();
            if (column instanceof SQLIdentifierExpr && SQLUtils.nameEquals(columnName, ((SQLIdentifierExpr)column).getName())) {
                return true;
            }
            if (!(column instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)column).getMethodName(), columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUNI(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            MySqlUnique unique;
            if (!(element instanceof MySqlUnique) || (unique = (MySqlUnique)element).getColumns().size() == 0) continue;
            SQLExpr column = unique.getColumns().get(0).getExpr();
            if (column instanceof SQLIdentifierExpr && SQLUtils.nameEquals(columnName, ((SQLIdentifierExpr)column).getName())) {
                return unique.columns.size() == 1;
            }
            if (!(column instanceof SQLMethodInvokeExpr) || !SQLUtils.nameEquals(((SQLMethodInvokeExpr)column).getMethodName(), columnName)) continue;
            return true;
        }
        return false;
    }

    public MySqlUnique findUnique(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            MySqlUnique unique;
            if (!(element instanceof MySqlUnique) || !(unique = (MySqlUnique)element).containsColumn(columnName)) continue;
            return unique;
        }
        return null;
    }

    public SQLTableElement findIndex(String columnName) {
        for (SQLTableElement element : this.tableElementList) {
            String keyColumName;
            SQLExpr columnExpr;
            if (element instanceof SQLUniqueConstraint) {
                SQLUniqueConstraint unique = (SQLUniqueConstraint)((Object)element);
                for (SQLSelectOrderByItem item : unique.getColumns()) {
                    columnExpr = item.getExpr();
                    if (!(columnExpr instanceof SQLIdentifierExpr)) continue;
                    keyColumName = ((SQLIdentifierExpr)columnExpr).getName();
                    if (!(keyColumName = SQLUtils.normalize(keyColumName)).equalsIgnoreCase(columnName)) continue;
                    return element;
                }
                continue;
            }
            if (!(element instanceof MySqlTableIndex)) continue;
            List<SQLSelectOrderByItem> indexColumns = ((MySqlTableIndex)element).getColumns();
            for (SQLSelectOrderByItem orderByItem : indexColumns) {
                columnExpr = orderByItem.getExpr();
                if (!(columnExpr instanceof SQLIdentifierExpr)) continue;
                keyColumName = ((SQLIdentifierExpr)columnExpr).getName();
                if (!(keyColumName = SQLUtils.normalize(keyColumName)).equalsIgnoreCase(columnName)) continue;
                return element;
            }
        }
        return null;
    }

    public void forEachColumn(Consumer<SQLColumnDefinition> columnConsumer) {
        if (columnConsumer == null) {
            return;
        }
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLColumnDefinition)) continue;
            columnConsumer.accept((SQLColumnDefinition)element);
        }
    }

    public SQLPrimaryKey findPrimaryKey() {
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLPrimaryKey)) continue;
            return (SQLPrimaryKey)element;
        }
        return null;
    }

    public List<SQLForeignKeyConstraint> findForeignKey() {
        ArrayList<SQLForeignKeyConstraint> fkList = new ArrayList<SQLForeignKeyConstraint>();
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            fkList.add((SQLForeignKeyConstraint)element);
        }
        return fkList;
    }

    public boolean hashForeignKey() {
        for (SQLTableElement element : this.tableElementList) {
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            return true;
        }
        return false;
    }

    public boolean isReferenced(SQLName tableName) {
        if (tableName == null) {
            return false;
        }
        return this.isReferenced(tableName.getSimpleName());
    }

    public boolean isReferenced(String tableName) {
        if (tableName == null) {
            return false;
        }
        tableName = SQLUtils.normalize(tableName);
        for (SQLTableElement element : this.tableElementList) {
            SQLForeignKeyConstraint fk;
            String refTableName;
            if (!(element instanceof SQLForeignKeyConstraint) || !SQLUtils.nameEquals(tableName, refTableName = (fk = (SQLForeignKeyConstraint)element).getReferencedTableName().getSimpleName())) continue;
            return true;
        }
        return false;
    }

    public SQLAlterTableStatement foreignKeyToAlterTable() {
        SQLAlterTableStatement stmt = new SQLAlterTableStatement();
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLTableElement element = this.tableElementList.get(i);
            if (!(element instanceof SQLForeignKeyConstraint)) continue;
            SQLForeignKeyConstraint fk = (SQLForeignKeyConstraint)element;
            this.tableElementList.remove(i);
            stmt.addItem(new SQLAlterTableAddConstraint(fk));
        }
        if (stmt.getItems().size() == 0) {
            return null;
        }
        stmt.setDbType(this.getDbType());
        stmt.setTableSource(this.tableSource.clone());
        Collections.reverse(stmt.getItems());
        return stmt;
    }

    public static void sort(List<SQLStatement> stmtList) {
        String fromTableName;
        SQLCreateTableStatement from;
        ListDG.Edge edge;
        int i;
        HashMap<Object, SQLCreateTableStatement> tables = new HashMap<Object, SQLCreateTableStatement>();
        HashMap<String, ArrayList<SQLCreateTableStatement>> referencedTables = new HashMap<String, ArrayList<SQLCreateTableStatement>>();
        for (SQLStatement sQLStatement : stmtList) {
            if (!(sQLStatement instanceof SQLCreateTableStatement)) continue;
            SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)sQLStatement;
            Object tableName = createTableStmt.getName().getSimpleName();
            tableName = SQLUtils.normalize((String)tableName).toLowerCase();
            tables.put(tableName, createTableStmt);
        }
        ArrayList<ListDG.Edge> edges = new ArrayList<ListDG.Edge>();
        for (SQLCreateTableStatement stmt : tables.values()) {
            for (SQLTableElement element : stmt.getTableElementList()) {
                ArrayList<SQLCreateTableStatement> referencedList;
                if (!(element instanceof SQLForeignKeyConstraint)) continue;
                SQLForeignKeyConstraint fk = (SQLForeignKeyConstraint)element;
                String refTableName = fk.getReferencedTableName().getSimpleName();
                SQLCreateTableStatement refTable = (SQLCreateTableStatement)tables.get(refTableName = SQLUtils.normalize(refTableName).toLowerCase());
                if (refTable != null) {
                    edges.add(new ListDG.Edge(stmt, refTable));
                }
                if ((referencedList = (ArrayList<SQLCreateTableStatement>)referencedTables.get(refTableName)) == null) {
                    referencedList = new ArrayList<SQLCreateTableStatement>();
                    referencedTables.put(refTableName, referencedList);
                }
                referencedList.add(stmt);
            }
        }
        ListDG listDG = new ListDG(stmtList, edges);
        Object[] tops = new SQLStatement[stmtList.size()];
        if (listDG.topologicalSort(tops)) {
            int size = stmtList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                stmtList.set(i2, (SQLStatement)tops[size - i2 - 1]);
            }
            return;
        }
        ArrayList<SQLAlterTableStatement> alterList = new ArrayList<SQLAlterTableStatement>();
        for (i = edges.size() - 1; i >= 0; --i) {
            edge = (ListDG.Edge)edges.get(i);
            from = (SQLCreateTableStatement)edge.from;
            fromTableName = from.getName().getSimpleName();
            if (!referencedTables.containsKey(fromTableName = SQLUtils.normalize(fromTableName).toLowerCase())) continue;
            edges.remove(i);
            Arrays.fill(tops, null);
            tops = new SQLStatement[stmtList.size()];
            ListDG listDG2 = new ListDG(stmtList, edges);
            if (listDG2.topologicalSort(tops)) {
                int size = stmtList.size();
                for (int j = 0; j < size; ++j) {
                    Object stmt = tops[size - j - 1];
                    stmtList.set(j, (SQLStatement)stmt);
                }
                SQLAlterTableStatement alter = from.foreignKeyToAlterTable();
                alterList.add(alter);
                stmtList.add(alter);
                return;
            }
            edges.add(i, edge);
        }
        for (i = edges.size() - 1; i >= 0; --i) {
            edge = (ListDG.Edge)edges.get(i);
            from = (SQLCreateTableStatement)edge.from;
            fromTableName = from.getName().getSimpleName();
            if (!referencedTables.containsKey(fromTableName = SQLUtils.normalize(fromTableName).toLowerCase())) continue;
            SQLAlterTableStatement alter = from.foreignKeyToAlterTable();
            edges.remove(i);
            if (alter != null) {
                alterList.add(alter);
            }
            Arrays.fill(tops, null);
            tops = new SQLStatement[stmtList.size()];
            ListDG listDG3 = new ListDG(stmtList, edges);
            if (!listDG3.topologicalSort(tops)) continue;
            int size = stmtList.size();
            for (int j = 0; j < size; ++j) {
                Object stmt = tops[size - j - 1];
                stmtList.set(j, (SQLStatement)stmt);
            }
            stmtList.addAll(alterList);
            return;
        }
    }

    public void simplify() {
        SQLIdentifierExpr identExpr;
        String tableName;
        String normalized;
        SQLName name = this.getName();
        if (name instanceof SQLPropertyExpr) {
            String normalized2;
            String tableName2 = ((SQLPropertyExpr)name).getName();
            if ((tableName2 = SQLUtils.normalize(tableName2)) != (normalized2 = SQLUtils.normalize(tableName2, this.dbType))) {
                this.setName(normalized2);
                name = this.getName();
            }
        }
        if (name instanceof SQLIdentifierExpr && (normalized = SQLUtils.normalize(tableName = (identExpr = (SQLIdentifierExpr)name).getName(), this.dbType)) != tableName) {
            this.setName(normalized);
        }
        for (SQLTableElement element : this.tableElementList) {
            if (element instanceof SQLColumnDefinition) {
                SQLColumnDefinition column = (SQLColumnDefinition)element;
                column.simplify();
                continue;
            }
            if (!(element instanceof SQLConstraint)) continue;
            ((SQLConstraint)((Object)element)).simplify();
        }
    }

    public boolean apply(SQLDropIndexStatement x) {
        long indexNameHashCode64 = x.getIndexName().nameHashCode64();
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            MySqlTableIndex tableIndex;
            SQLTableElement e = this.tableElementList.get(i);
            if (e instanceof SQLUniqueConstraint) {
                SQLUniqueConstraint unique = (SQLUniqueConstraint)((Object)e);
                if (unique.getName().nameHashCode64() != indexNameHashCode64) continue;
                this.tableElementList.remove(i);
                return true;
            }
            if (!(e instanceof MySqlTableIndex) || !SQLUtils.nameEquals((tableIndex = (MySqlTableIndex)e).getName(), x.getIndexName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    public boolean apply(SQLCommentStatement x) {
        SQLName on = x.getOn();
        SQLExpr comment = x.getComment();
        if (comment == null) {
            return false;
        }
        SQLCommentStatement.Type type = x.getType();
        if (type == SQLCommentStatement.Type.TABLE) {
            if (!SQLUtils.nameEquals(this.getName(), on)) {
                return false;
            }
            this.setComment(comment.clone());
            return true;
        }
        if (type == SQLCommentStatement.Type.COLUMN) {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)on;
            if (!SQLUtils.nameEquals(this.getName(), (SQLName)propertyExpr.getOwner())) {
                return false;
            }
            SQLColumnDefinition column = this.findColumn(propertyExpr.nameHashCode64());
            if (column != null) {
                column.setComment(comment.clone());
            }
            return true;
        }
        return false;
    }

    public boolean apply(SQLAlterTableStatement alter) {
        if (!SQLUtils.nameEquals(alter.getName(), this.getName())) {
            return false;
        }
        int applyCount = 0;
        for (SQLAlterTableItem item : alter.getItems()) {
            if (!this.alterApply(item)) continue;
            ++applyCount;
        }
        return applyCount > 0;
    }

    protected boolean alterApply(SQLAlterTableItem item) {
        if (item instanceof SQLAlterTableDropColumnItem) {
            return this.apply((SQLAlterTableDropColumnItem)item);
        }
        if (item instanceof SQLAlterTableAddColumn) {
            return this.apply((SQLAlterTableAddColumn)item);
        }
        if (item instanceof SQLAlterTableAddConstraint) {
            return this.apply((SQLAlterTableAddConstraint)item);
        }
        if (item instanceof SQLAlterTableDropPrimaryKey) {
            return this.apply((SQLAlterTableDropPrimaryKey)item);
        }
        if (item instanceof SQLAlterTableDropIndex) {
            return this.apply((SQLAlterTableDropIndex)item);
        }
        if (item instanceof SQLAlterTableDropConstraint) {
            return this.apply((SQLAlterTableDropConstraint)item);
        }
        if (item instanceof SQLAlterTableDropKey) {
            return this.apply((SQLAlterTableDropKey)item);
        }
        if (item instanceof SQLAlterTableDropForeignKey) {
            return this.apply((SQLAlterTableDropForeignKey)item);
        }
        if (item instanceof SQLAlterTableRename) {
            return this.apply((SQLAlterTableRename)item);
        }
        if (item instanceof SQLAlterTableRenameColumn) {
            return this.apply((SQLAlterTableRenameColumn)item);
        }
        if (item instanceof SQLAlterTableAddIndex) {
            return this.apply((SQLAlterTableAddIndex)item);
        }
        return false;
    }

    private boolean apply(SQLAlterTableRenameColumn item) {
        int columnIndex = this.columnIndexOf(item.getColumn());
        if (columnIndex == -1) {
            return false;
        }
        SQLColumnDefinition column = (SQLColumnDefinition)this.tableElementList.get(columnIndex);
        column.setName(item.getTo().clone());
        return true;
    }

    private boolean apply(SQLAlterTableRename item) {
        SQLName name = item.getToName();
        if (name == null) {
            return false;
        }
        this.setName(name.clone());
        return true;
    }

    private boolean apply(SQLAlterTableDropForeignKey item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLForeignKeyConstraint fk;
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLUniqueConstraint) || !SQLUtils.nameEquals((fk = (SQLForeignKeyConstraint)e).getName(), item.getIndexName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropKey item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLUniqueConstraint unique;
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLUniqueConstraint) || !SQLUtils.nameEquals((unique = (SQLUniqueConstraint)((Object)e)).getName(), item.getKeyName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropConstraint item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLConstraint constraint;
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLConstraint) || !SQLUtils.nameEquals((constraint = (SQLConstraint)((Object)e)).getName(), item.getConstraintName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropIndex item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            MySqlTableIndex tableIndex;
            SQLTableElement e = this.tableElementList.get(i);
            if (e instanceof SQLUniqueConstraint) {
                SQLUniqueConstraint unique = (SQLUniqueConstraint)((Object)e);
                if (!SQLUtils.nameEquals(unique.getName(), item.getIndexName())) continue;
                this.tableElementList.remove(i);
                return true;
            }
            if (!(e instanceof MySqlTableIndex) || !SQLUtils.nameEquals((tableIndex = (MySqlTableIndex)e).getName(), item.getIndexName())) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableDropPrimaryKey item) {
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLPrimaryKey)) continue;
            this.tableElementList.remove(i);
            return true;
        }
        return false;
    }

    private boolean apply(SQLAlterTableAddConstraint item) {
        this.tableElementList.add((SQLTableElement)((Object)item.getConstraint()));
        return true;
    }

    private boolean apply(SQLAlterTableDropColumnItem item) {
        for (SQLName column : item.getColumns()) {
            SQLTableElement e;
            int i;
            String columnName = column.getSimpleName();
            for (i = this.tableElementList.size() - 1; i >= 0; --i) {
                e = this.tableElementList.get(i);
                if (!(e instanceof SQLColumnDefinition) || !SQLUtils.nameEquals(columnName, ((SQLColumnDefinition)e).getName().getSimpleName())) continue;
                this.tableElementList.remove(i);
            }
            for (i = this.tableElementList.size() - 1; i >= 0; --i) {
                e = this.tableElementList.get(i);
                if (e instanceof SQLUnique) {
                    SQLUnique unique = (SQLUnique)e;
                    unique.applyDropColumn(column);
                    if (unique.getColumns().size() != 0) continue;
                    this.tableElementList.remove(i);
                    continue;
                }
                if (!(e instanceof MySqlTableIndex)) continue;
                MySqlTableIndex index = (MySqlTableIndex)e;
                index.applyDropColumn(column);
                if (index.getColumns().size() != 0) continue;
                this.tableElementList.remove(i);
            }
        }
        return true;
    }

    protected boolean apply(SQLAlterTableAddIndex item) {
        return false;
    }

    private boolean apply(SQLAlterTableAddColumn item) {
        int beforeIndex;
        int afterIndex;
        int startIndex = this.tableElementList.size();
        if (item.isFirst()) {
            startIndex = 0;
        }
        if ((afterIndex = this.columnIndexOf(item.getAfterColumn())) != -1) {
            startIndex = afterIndex + 1;
        }
        if ((beforeIndex = this.columnIndexOf(item.getFirstColumn())) != -1) {
            startIndex = beforeIndex;
        }
        for (int i = 0; i < item.getColumns().size(); ++i) {
            SQLColumnDefinition column = item.getColumns().get(i);
            this.tableElementList.add(i + startIndex, column);
            column.setParent(this);
        }
        return true;
    }

    protected int columnIndexOf(SQLName column) {
        if (column == null) {
            return -1;
        }
        String columnName = column.getSimpleName();
        for (int i = this.tableElementList.size() - 1; i >= 0; --i) {
            SQLTableElement e = this.tableElementList.get(i);
            if (!(e instanceof SQLColumnDefinition) || !SQLUtils.nameEquals(columnName, ((SQLColumnDefinition)e).getName().getSimpleName())) continue;
            return i;
        }
        return -1;
    }

    public void cloneTo(SQLCreateTableStatement x) {
        x.ifNotExiists = this.ifNotExiists;
        x.type = this.type;
        if (this.tableSource != null) {
            x.setTableSource(this.tableSource.clone());
        }
        for (SQLTableElement e : this.tableElementList) {
            SQLTableElement e2 = e.clone();
            e2.setParent(x);
            x.tableElementList.add(e2);
        }
        if (this.inherits != null) {
            x.setInherits(this.inherits.clone());
        }
        if (this.select != null) {
            x.setSelect(this.select.clone());
        }
        if (this.comment != null) {
            x.setComment(this.comment.clone());
        }
    }

    @Override
    public SQLCreateTableStatement clone() {
        SQLCreateTableStatement x = new SQLCreateTableStatement(this.dbType);
        this.cloneTo(x);
        return x;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.dbType);
    }

    public static enum Type {
        GLOBAL_TEMPORARY,
        LOCAL_TEMPORARY;

    }
}

