/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm.refresh;

import com.alibaba.cloud.acm.AcmProperties;
import com.alibaba.cloud.acm.AcmPropertySourceRepository;
import com.alibaba.cloud.acm.bootstrap.AcmPropertySource;
import com.alibaba.cloud.acm.refresh.AcmRefreshHistory;
import com.alibaba.cloud.acm.refresh.AcmRefreshProperties;
import com.alibaba.edas.acm.ConfigService;
import com.alibaba.edas.acm.listener.ConfigChangeListener;
import com.alibaba.edas.acm.listener.ConfigChangeListenerAdapter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.context.ApplicationListener;
import org.springframework.util.StringUtils;

public class AcmContextRefresher
implements ApplicationListener<ApplicationReadyEvent> {
    private Logger logger = LoggerFactory.getLogger(AcmContextRefresher.class);
    private final ContextRefresher contextRefresher;
    private final AcmProperties properties;
    private final AcmRefreshProperties refreshProperties;
    private final AcmRefreshHistory refreshHistory;
    private final AcmPropertySourceRepository acmPropertySourceRepository;

    public AcmContextRefresher(ContextRefresher contextRefresher, AcmProperties properties, AcmRefreshProperties refreshProperties, AcmRefreshHistory refreshHistory, AcmPropertySourceRepository acmPropertySourceRepository) {
        this.contextRefresher = contextRefresher;
        this.properties = properties;
        this.refreshProperties = refreshProperties;
        this.refreshHistory = refreshHistory;
        this.acmPropertySourceRepository = acmPropertySourceRepository;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.registerDiamondListenersForApplications();
    }

    private void registerDiamondListenersForApplications() {
        if (this.refreshProperties.isEnabled()) {
            for (AcmPropertySource acmPropertySource : this.acmPropertySourceRepository.getAll()) {
                if (acmPropertySource.isGroupLevel()) continue;
                String dataId = acmPropertySource.getDataId();
                this.registerDiamondListener(dataId);
            }
        }
    }

    private void registerDiamondListener(final String dataId) {
        ConfigService.addListener((String)dataId, (String)this.properties.getGroup(), (ConfigChangeListenerAdapter)new ConfigChangeListener(){

            public void receiveConfigInfo(String configInfo) {
                String md5 = "";
                if (!StringUtils.isEmpty((Object)configInfo)) {
                    try {
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        md5 = new BigInteger(1, md.digest(configInfo.getBytes("UTF-8"))).toString(16);
                    }
                    catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                        AcmContextRefresher.this.logger.warn("unable to get md5 for dataId: " + dataId, (Throwable)e);
                    }
                }
                AcmContextRefresher.this.refreshHistory.add(dataId, md5);
                AcmContextRefresher.this.contextRefresher.refresh();
            }
        });
    }
}

