/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm.endpoint;

import com.alibaba.cloud.acm.AcmProperties;
import com.alibaba.cloud.acm.AcmPropertySourceRepository;
import com.alibaba.cloud.acm.bootstrap.AcmPropertySource;
import com.taobao.diamond.maintenance.DiamondHealth;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class AcmHealthIndicator
extends AbstractHealthIndicator {
    private static final String UP = "UP";
    private static final String DOWN = "DOWN";
    private final AcmPropertySourceRepository acmPropertySourceRepository;
    private final List<String> dataIds;

    public AcmHealthIndicator(AcmProperties acmProperties, AcmPropertySourceRepository acmPropertySourceRepository) {
        this.acmPropertySourceRepository = acmPropertySourceRepository;
        this.dataIds = new ArrayList<String>();
        for (AcmPropertySource acmPropertySource : this.acmPropertySourceRepository.getAll()) {
            this.dataIds.add(acmPropertySource.getDataId());
        }
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.withDetail("dataIds", this.dataIds);
        String status = DiamondHealth.getHealth();
        if (UP.equals(status)) {
            builder.up();
        } else if (status.startsWith(DOWN)) {
            builder.down();
        } else {
            builder.unknown();
        }
    }
}

