/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm.bootstrap;

import com.alibaba.cloud.acm.bootstrap.AcmPropertySource;
import com.alibaba.cloud.acm.bootstrap.AcmPropertySourceBuilder;
import com.alibaba.cloud.acm.diagnostics.analyzer.DiamondConnectionFailureException;
import com.alibaba.edas.acm.ConfigService;
import com.taobao.diamond.client.impl.ServerHttpAgent;
import com.taobao.diamond.client.impl.TenantUtil;
import com.taobao.diamond.identify.CredentialService;
import com.taobao.diamond.maintenance.DiamondHealth;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class AcmPropertySourceLocator
implements PropertySourceLocator {
    private final Logger logger = LoggerFactory.getLogger(AcmPropertySourceLocator.class);
    private static final String DIAMOND_PROPERTY_SOURCE_NAME = "diamond";
    private static String defaultDiamondGroup = "DEFAULT_GROUP";
    private AcmPropertySourceBuilder acmPropertySourceBuilder = new AcmPropertySourceBuilder();

    public void setAcmPropertySourceBuilder(AcmPropertySourceBuilder acmPropertySourceBuilder) {
        this.acmPropertySourceBuilder = acmPropertySourceBuilder;
    }

    public PropertySource<?> locate(Environment environment) {
        String diamondGroupTmp;
        String accessKey;
        String namespace;
        String endpoint = System.getProperty("address.server.domain");
        if (StringUtils.isEmpty((Object)endpoint)) {
            endpoint = environment.getProperty("alibaba.acm.endpoint");
        }
        if (StringUtils.isEmpty((Object)(namespace = TenantUtil.getUserTenant()))) {
            namespace = environment.getProperty("alibaba.acm.namespace");
        }
        if (StringUtils.isEmpty((Object)(accessKey = CredentialService.getInstance().getCredential().getAccessKey()))) {
            accessKey = environment.getProperty("alibaba.acm.accessKey");
            this.logger.info("Initialize alibaba.acm.accessKey '{}''", (Object)accessKey);
        } else {
            this.logger.info("Initialize credential accessKey '{}'", (Object)accessKey);
        }
        String secretKey = CredentialService.getInstance().getCredential().getSecretKey();
        if (StringUtils.isEmpty((Object)secretKey)) {
            secretKey = environment.getProperty("alibaba.acm.secretKey");
        }
        if (!StringUtils.isEmpty((Object)(diamondGroupTmp = environment.getProperty("alibaba.acm.group")))) {
            defaultDiamondGroup = diamondGroupTmp;
        }
        try {
            this.logger.info("Initialize ACM on endpoint '" + endpoint + "', namespace '" + namespace + "'.");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initialize ACM with default group '" + defaultDiamondGroup);
                this.logger.debug("Initialize ACM with accessKey '" + accessKey + "', secretKey '" + secretKey + "'.");
            }
            String openKMSFilterStr = environment.getProperty("alibaba.acm.openKMSFilter");
            this.logger.info("Initialize alibaba.acm.openKMSFilter '" + openKMSFilterStr + "'.");
            String regionId = environment.getProperty("alibaba.acm.regionId");
            this.logger.info("Initialize alibaba.acm.regionId '" + regionId + "'.");
            String keyId = environment.getProperty("alibaba.acm.keyId");
            this.logger.info("Initialize alibaba.acm.keyId '" + keyId + "'.");
            Properties properties = new Properties();
            if (!StringUtils.isEmpty((Object)endpoint)) {
                properties.put("endpoint", endpoint);
            }
            if (!StringUtils.isEmpty((Object)namespace)) {
                properties.put("namespace", namespace);
            }
            if (!StringUtils.isEmpty((Object)accessKey)) {
                properties.put("accessKey", accessKey);
            }
            if (!StringUtils.isEmpty((Object)secretKey)) {
                properties.put("secretKey", secretKey);
            }
            if ("true".equals(openKMSFilterStr)) {
                properties.put("openKMSFilter", (Object)true);
            }
            if (!StringUtils.isEmpty((Object)regionId)) {
                properties.put("regionId", regionId);
            }
            if (!StringUtils.isEmpty((Object)keyId)) {
                properties.put("keyId", keyId);
            }
            this.putProperties(environment, properties, "alibaba.acm.ramRoleName", "ramRoleName");
            this.putProperties(environment, properties, "alibaba.acm.timeToRefreshInMillisecond", "timeToRefreshInMillisecond");
            this.putProperties(environment, properties, "alibaba.acm.securityCredentials", "securityCredentials");
            this.putProperties(environment, properties, "alibaba.acm.securityCredentialsUrl", "securityCredentialsUrl");
            this.putProperties(environment, properties, "alibaba.acm.cacheSecurityCredentials", "cacheSecurityCredentials");
            ConfigService.init((Properties)properties);
        }
        catch (Throwable t) {
            throw new DiamondConnectionFailureException(ServerHttpAgent.domainName, ServerHttpAgent.addressPort, "ACM environment initialization error", t);
        }
        this.checkDiamondHealth();
        String applicationName = environment.getProperty("spring.application.name");
        this.logger.info("Initialize spring.application.name '" + applicationName + "'.");
        String applicationGroup = environment.getProperty("spring.application.group");
        if (StringUtils.isEmpty((Object)applicationName)) {
            throw new IllegalStateException("'spring.application.name' must be configured.");
        }
        if (StringUtils.isEmpty((Object)applicationGroup)) {
            throw new IllegalStateException("'spring.application.group' must be configured.");
        }
        String[] groupParts = applicationGroup.split("\\.");
        if (groupParts.length < 3) {
            throw new IllegalStateException("spring.application.group '" + applicationGroup + "' must be something like [com].[bu].[product] or [com].[alibaba].[bu].[product], e.g. com.aliexpress.fileserver, com.alibaba.da.coin");
        }
        String fileExtension = environment.getProperty("alibaba.acm.file-extension");
        if (fileExtension == null && (fileExtension = environment.getProperty("alibaba.acm.fileExtension")) == null) {
            fileExtension = "properties";
        }
        this.logger.info("Initialize alibaba.acm.fileExtension '{}'", (Object)fileExtension);
        CompositePropertySource compositePropertySource = new CompositePropertySource(DIAMOND_PROPERTY_SOURCE_NAME);
        this.loadGroupConfigurationRecursively(compositePropertySource, applicationGroup, fileExtension);
        this.loadApplicationConfiguration(compositePropertySource, environment, applicationGroup, applicationName, fileExtension);
        return compositePropertySource;
    }

    private void putProperties(Environment environment, Properties properties, String appPropertyKey, String initPropertyKey) {
        String value = environment.getProperty(appPropertyKey);
        if (!StringUtils.isEmpty((Object)value)) {
            properties.put(initPropertyKey, value);
            this.logger.info("Initialize {} '{}'.", (Object)appPropertyKey, (Object)value);
        }
    }

    private void checkDiamondHealth() {
        this.logger.info("Checking ACM health");
        try {
            if (!DiamondHealth.getHealth().equals("UP")) {
                throw new DiamondConnectionFailureException(ServerHttpAgent.domainName, ServerHttpAgent.addressPort, DiamondHealth.getHealth());
            }
        }
        catch (Throwable t) {
            throw new DiamondConnectionFailureException(ServerHttpAgent.domainName, ServerHttpAgent.addressPort, "ACM Health error", t);
        }
    }

    private void loadGroupConfigurationRecursively(CompositePropertySource compositePropertySource, String applicationGroup, String fileExtension) {
        String[] parts = applicationGroup.split("\\.");
        for (int i = 1; i < parts.length; ++i) {
            String subGroup = parts[0];
            for (int j = 1; j <= i; ++j) {
                subGroup = subGroup + "." + parts[j];
            }
            this.loadDiamondDataIfPresent(compositePropertySource, subGroup + ":application." + fileExtension, defaultDiamondGroup, true);
        }
    }

    private void loadApplicationConfiguration(CompositePropertySource compositePropertySource, Environment environment, String applicationGroup, String applicationName, String fileExtension) {
        this.loadDiamondDataIfPresent(compositePropertySource, applicationGroup + ":" + applicationName + "." + fileExtension, defaultDiamondGroup, false);
        for (String profile : environment.getActiveProfiles()) {
            this.loadDiamondDataIfPresent(compositePropertySource, applicationGroup + ":" + applicationName + "-" + profile + "." + fileExtension, defaultDiamondGroup, false);
        }
    }

    private void loadDiamondDataIfPresent(CompositePropertySource composite, String dataId, String diamondGroup, boolean groupLevel) {
        AcmPropertySource ps = this.acmPropertySourceBuilder.build(dataId, diamondGroup, groupLevel);
        if (ps != null) {
            composite.addFirstPropertySource((PropertySource)ps);
        }
    }
}

