/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.acm.bootstrap;

import com.alibaba.cloud.acm.bootstrap.AcmPropertySource;
import com.alibaba.cloud.acm.bootstrap.DiamondProxy;
import com.alibaba.cloud.acm.bootstrap.DiamondProxyImpl;
import com.alibaba.edas.acm.exception.ConfigException;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

class AcmPropertySourceBuilder {
    private DiamondProxy diamondProxy = new DiamondProxyImpl();
    private Logger logger = LoggerFactory.getLogger(AcmPropertySourceBuilder.class);

    AcmPropertySourceBuilder() {
    }

    DiamondProxy getDiamondProxy() {
        return this.diamondProxy;
    }

    void setDiamondProxy(DiamondProxy diamondProxy) {
        this.diamondProxy = diamondProxy;
    }

    AcmPropertySource build(String dataId, String diamondGroup, boolean groupLevel) {
        Properties p = this.loadDiamondData(dataId, diamondGroup);
        if (p == null) {
            return null;
        }
        return new AcmPropertySource(dataId, this.toMap(p), new Date(), groupLevel);
    }

    private Properties loadDiamondData(String dataId, String diamondGroup) {
        try {
            String data = this.getDiamondProxy().getConfig(dataId, diamondGroup, 3000L);
            if (!StringUtils.isEmpty((Object)data)) {
                this.logger.info(String.format("Loading acm data, dataId: '%s', group: '%s'", dataId, diamondGroup));
                if (dataId.endsWith(".yaml") || dataId.endsWith(".yml")) {
                    YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
                    yamlFactory.setResources(new Resource[]{new ByteArrayResource(data.getBytes("UTF-8"))});
                    return yamlFactory.getObject();
                }
                Properties properties = new Properties();
                properties.load(new StringReader(data));
                return properties;
            }
        }
        catch (Exception e) {
            if (e instanceof ConfigException) {
                this.logger.error("DIAMOND-100500:" + dataId + ", " + e.toString(), (Throwable)e);
            }
            this.logger.error("DIAMOND-100500:" + dataId, (Throwable)e);
        }
        return null;
    }

    private Map<String, Object> toMap(Properties properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            if (value != null) {
                result.put(key, value.trim());
                continue;
            }
            result.put(key, null);
        }
        return result;
    }
}

