/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.context.ans;

import com.alibaba.cloud.context.AliCloudServerMode;
import com.alibaba.cloud.context.ans.AnsConfiguration;
import com.alibaba.cloud.context.utils.NetUtils;
import com.alibaba.cloud.context.utils.StringUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class SimpleAnsConfiguration
implements AnsConfiguration {
    private AliCloudServerMode serverMode = AliCloudServerMode.LOCAL;
    private String serverList = "127.0.0.1";
    private String serverPort = "8080";
    private String clientDomains;
    private float clientWeight = 1.0f;
    private Map<String, Float> clientWeights = new HashMap<String, Float>();
    private String clientToken;
    private Map<String, String> clientTokens = new HashMap<String, String>();
    private String clientCluster = "DEFAULT";
    private Map<String, String> clientMetadata = new HashMap<String, String>();
    private boolean registerEnabled = true;
    private String clientIp;
    private String clientInterfaceName;
    private int clientPort = -1;
    private String env;
    private boolean secure = false;
    private Map<String, String> tags = new HashMap<String, String>();

    public SimpleAnsConfiguration() {
        this.tags.put("ANS_SERVICE_TYPE", "SPRING_CLOUD");
        this.clientIp = NetUtils.findFirstNonLoopbackAddress().getHostAddress();
    }

    public SimpleAnsConfiguration(String serverList, String serverPort) {
        this.serverList = serverList;
        this.serverPort = serverPort;
    }

    public void setServerMode(AliCloudServerMode serverMode) {
        this.serverMode = serverMode;
    }

    public void setServerList(String serverList) {
        this.serverList = serverList;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setClientDomains(String clientDomains) {
        this.clientDomains = clientDomains;
    }

    public void setClientWeight(float clientWeight) {
        this.clientWeight = clientWeight;
    }

    public void setClientWeights(Map<String, Float> clientWeights) {
        this.clientWeights = clientWeights;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public void setClientTokens(Map<String, String> clientTokens) {
        this.clientTokens = clientTokens;
    }

    public void setClientCluster(String clientCluster) {
        this.clientCluster = clientCluster;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public void setRegisterEnabled(boolean registerEnabled) {
        this.registerEnabled = registerEnabled;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setClientInterfaceName(String clientInterfaceName) {
        NetworkInterface networkInterface;
        this.clientInterfaceName = clientInterfaceName;
        try {
            networkInterface = NetworkInterface.getByName(clientInterfaceName);
        }
        catch (SocketException e) {
            throw new RuntimeException("get network interface " + clientInterfaceName + "failed.", e);
        }
        if (null == networkInterface) {
            throw new RuntimeException("no such network interface " + clientInterfaceName);
        }
        Enumeration<InetAddress> inetAddress = networkInterface.getInetAddresses();
        while (inetAddress.hasMoreElements()) {
            InetAddress currentAddress = inetAddress.nextElement();
            if (!(currentAddress instanceof Inet4Address) || currentAddress.isLoopbackAddress()) continue;
            this.clientIp = currentAddress.getHostAddress();
            break;
        }
        if (StringUtils.isEmpty(this.clientIp)) {
            throw new RuntimeException("cannot find available ip from network interface " + clientInterfaceName);
        }
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public AliCloudServerMode getServerMode() {
        return this.serverMode;
    }

    @Override
    public String getServerList() {
        return this.serverList;
    }

    @Override
    public String getServerPort() {
        return this.serverPort;
    }

    @Override
    public String getClientDomains() {
        return this.clientDomains;
    }

    @Override
    public float getClientWeight() {
        return this.clientWeight;
    }

    @Override
    public Map<String, Float> getClientWeights() {
        return this.clientWeights;
    }

    @Override
    public String getClientToken() {
        return this.clientToken;
    }

    @Override
    public Map<String, String> getClientTokens() {
        return this.clientTokens;
    }

    @Override
    public String getClientCluster() {
        return this.clientCluster;
    }

    @Override
    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    @Override
    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    @Override
    public String getClientIp() {
        return this.clientIp;
    }

    @Override
    public String getClientInterfaceName() {
        return this.clientInterfaceName;
    }

    @Override
    public int getClientPort() {
        return this.clientPort;
    }

    @Override
    public String getEnv() {
        return this.env;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }
}

